/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.actions;

import io.hyscale.troubleshooting.integration.models.AbstractedErrorMessage;
import io.hyscale.troubleshooting.integration.models.ActionNode;
import io.hyscale.troubleshooting.integration.models.DiagnosisReport;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import io.kubernetes.client.openapi.models.V1Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FixHealthCheckAction
extends ActionNode<TroubleshootingContext> {
    private static final Logger logger = LoggerFactory.getLogger(FixHealthCheckAction.class);

    @Override
    public void process(TroubleshootingContext context) {
        Object obj = context.getAttribute(FailedResourceKey.UNHEALTHY_POD_EVENT);
        String eventMessage = null;
        if (obj != null) {
            V1Event event = (V1Event)FailedResourceKey.UNHEALTHY_POD_EVENT.getKlazz().cast(obj);
            eventMessage = event != null ? event.getMessage() : null;
            logger.debug("Fix health check, pod event: {}", (Object)eventMessage);
        }
        DiagnosisReport report = new DiagnosisReport();
        report.setReason(AbstractedErrorMessage.LIVENESS_PROBE_FAILURE.getReason());
        report.setRecommendedFix(AbstractedErrorMessage.LIVENESS_PROBE_FAILURE.getMessage());
        context.addReport(report);
    }

    @Override
    public String describe() {
        return "Fix Liveness probe ";
    }
}

