/*
 * Decompiled with CFR 0.152.
 */
package io.hyscale.troubleshooting.integration.actions;

import io.hyscale.troubleshooting.integration.models.AbstractedErrorMessage;
import io.hyscale.troubleshooting.integration.models.ActionNode;
import io.hyscale.troubleshooting.integration.models.DiagnosisReport;
import io.hyscale.troubleshooting.integration.models.FailedResourceKey;
import io.hyscale.troubleshooting.integration.models.TroubleshootingContext;
import org.springframework.stereotype.Component;

@Component
public class DefaultAction
extends ActionNode<TroubleshootingContext> {
    private static final String KUBERNETES_ERROR_MESSAGE = "Kubernetes error message follows: \n %s";

    @Override
    public void process(TroubleshootingContext context) {
        Object obj = context.getAttribute(FailedResourceKey.OBSERVED_POD_STATUS);
        String errorMessage = null;
        if (obj instanceof String) {
            errorMessage = String.format(KUBERNETES_ERROR_MESSAGE, (String)FailedResourceKey.OBSERVED_POD_STATUS.getKlazz().cast(obj));
        }
        DiagnosisReport report = new DiagnosisReport();
        report.setReason(AbstractedErrorMessage.CANNOT_INFER_ERROR.getReason());
        report.setRecommendedFix(AbstractedErrorMessage.CANNOT_INFER_ERROR.formatMessage(errorMessage));
        context.addReport(report);
    }

    @Override
    public String describe() {
        return "Default Action when error cannot be inferred from the service state";
    }
}

