/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.spring.repo.querymethod;

import io.hypersistence.utils.spring.repo.querymethod.PostCommentRepository;
import io.hypersistence.utils.spring.repo.querymethod.PostRepository;
import io.hypersistence.utils.spring.repo.querymethod.SpringDataJPAQueryMethodConfiguration;
import io.hypersistence.utils.spring.repo.querymethod.domain.Post;
import io.hypersistence.utils.spring.repo.querymethod.domain.PostComment;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={SpringDataJPAQueryMethodConfiguration.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class SpringDataJPAQueryMethodTest {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private PostRepository postRepository;
    @Autowired
    private PostCommentRepository postCommentRepository;

    @Test
    public void testDeleteMethod() {
        this.transactionTemplate.execute(transactionStatus -> {
            Post post1 = new Post().addPostComment(new PostComment());
            Post post2 = new Post();
            Assert.assertEquals((long)0L, (long)this.postRepository.count());
            Assert.assertEquals((long)0L, (long)this.postCommentRepository.count());
            this.postRepository.save(post1);
            this.postRepository.save(post2);
            Assert.assertEquals((long)2L, (long)this.postRepository.count());
            Assert.assertEquals((long)1L, (long)this.postCommentRepository.count());
            this.postRepository.deleteByCommentsIsNull();
            Assert.assertEquals((long)1L, (long)this.postRepository.count());
            Assert.assertEquals((long)1L, (long)this.postCommentRepository.count());
            this.postRepository.delete(post1);
            Assert.assertEquals((long)0L, (long)this.postRepository.count());
            Assert.assertEquals((long)0L, (long)this.postCommentRepository.count());
            return null;
        });
    }
}

