/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.spring.repo.projection;

import io.hypersistence.utils.spring.domain.Post;
import io.hypersistence.utils.spring.repo.projection.PostRepository;
import io.hypersistence.utils.spring.repo.projection.SpringDataProjectionConfiguration;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={SpringDataProjectionConfiguration.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class SpringDataProjectionTest {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private PostRepository postRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Test
    public void test() {
        this.transactionTemplate.execute(transactionStatus -> {
            this.postRepository.persist(new Post().setId(1L).setTitle("test title").setSlug("slug1"));
            this.postRepository.persistAndFlush(new Post().setId(2L).setTitle("test title").setSlug("slug2"));
            return null;
        });
        List postsSummary = (List)this.transactionTemplate.execute(transactionStatus -> this.postRepository.findAllSlugGroupedByTitle());
        PostRepository.TestProjection result = (PostRepository.TestProjection)postsSummary.get(0);
        Assert.assertEquals((Object)"test title", (Object)result.getTitle());
        ArrayList<String> expectedSlugs = new ArrayList<String>();
        expectedSlugs.add("slug1");
        expectedSlugs.add("slug2");
        Assert.assertEquals(expectedSlugs, result.getSlugs());
    }
}

