/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.spring.repo.hibernate;

import io.hypersistence.utils.spring.domain.Post;
import io.hypersistence.utils.spring.repo.hibernate.PostRepository;
import io.hypersistence.utils.spring.repo.hibernate.SpringDataJPAHibernateConfiguration;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={SpringDataJPAHibernateConfiguration.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class SpringDataJPAHibernateTest {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private PostRepository postRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Test
    public void testPersistAndMerge() {
        String slug = "high-performance-java-persistence";
        this.transactionTemplate.execute(transactionStatus -> {
            this.postRepository.persist(new Post().setId(1L).setTitle("High-Performance Java Persistence").setSlug("high-performance-java-persistence"));
            this.postRepository.persistAndFlush(new Post().setId(2L).setTitle("Hypersistence Optimizer").setSlug("hypersistence-optimizer"));
            this.postRepository.persistAllAndFlush(LongStream.range(3L, 1000L).mapToObj(i -> new Post().setId(i).setTitle(String.format("Post %d", i)).setSlug(String.format("post-%d", i))).collect(Collectors.toList()));
            return null;
        });
        List posts = (List)this.transactionTemplate.execute(transactionStatus -> this.entityManager.createQuery("select p from Post p where p.id < 10", Post.class).getResultList());
        posts.forEach(post -> post.setTitle(post.getTitle() + " rocks!"));
        this.transactionTemplate.execute(transactionStatus -> this.postRepository.updateAll(posts));
    }

    @Test
    public void testSave() {
        try {
            this.transactionTemplate.execute(transactionStatus -> {
                this.postRepository.save(new Post().setId(1L).setTitle("High-Performance Java Persistence").setSlug("high-performance-java-persistence"));
                return null;
            });
            Assert.fail((String)"Should throw UnsupportedOperationException!");
        }
        catch (UnsupportedOperationException expected) {
            this.LOGGER.warn("You shouldn't call the JpaRepository save method!");
        }
    }

    @Test
    public void testFindAll() {
        try {
            this.transactionTemplate.execute(transactionStatus -> {
                this.postRepository.findAll();
                return null;
            });
            Assert.fail((String)"Should throw UnsupportedOperationException!");
        }
        catch (UnsupportedOperationException expected) {
            this.LOGGER.warn("You shouldn't call the JpaRepository findAll method!");
        }
    }
}

