/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.spring.repo.base;

import io.hypersistence.utils.spring.domain.Post;
import io.hypersistence.utils.spring.repo.base.PostRepository;
import io.hypersistence.utils.spring.repo.base.SpringDataJPABaseConfiguration;
import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.PersistenceContext;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={SpringDataJPABaseConfiguration.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class SpringDataJPABaseTest {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private PostRepository postRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Test
    public void testPersistAndMerge() {
        String slug = "high-performance-java-persistence";
        this.transactionTemplate.execute(transactionStatus -> {
            this.postRepository.persist(new Post().setId(1L).setTitle("High-Performance Java Persistence").setSlug("high-performance-java-persistence"));
            this.postRepository.persistAndFlush(new Post().setId(2L).setTitle("Hypersistence Optimizer").setSlug("hypersistence-optimizer"));
            this.postRepository.persistAllAndFlush(LongStream.range(3L, 1000L).mapToObj(i -> new Post().setId(i).setTitle(String.format("Post %d", i)).setSlug(String.format("post-%d", i))).collect(Collectors.toList()));
            return null;
        });
        List posts = (List)this.transactionTemplate.execute(transactionStatus -> this.entityManager.createQuery("select p from Post p where p.id < 10", Post.class).getResultList());
        posts.forEach(post -> post.setTitle(post.getTitle() + " rocks!"));
        this.transactionTemplate.execute(transactionStatus -> this.postRepository.updateAll(posts));
    }

    @Test
    public void testLockById() {
        this.transactionTemplate.execute(transactionStatus -> {
            this.postRepository.persist(new Post().setId(1L).setTitle("High-Performance Java Persistence").setSlug("high-performance-java-persistence"));
            return null;
        });
        this.transactionTemplate.execute(transactionStatus -> {
            Post post = (Post)this.postRepository.lockById(1L, LockModeType.PESSIMISTIC_WRITE);
            Assert.assertEquals((Object)LockModeType.PESSIMISTIC_WRITE, (Object)this.entityManager.getLockMode((Object)post));
            return null;
        });
    }

    @Test
    public void testGetReferenceById() {
        this.transactionTemplate.execute(transactionStatus -> {
            this.postRepository.persist(new Post().setId(1L).setTitle("High-Performance Java Persistence").setSlug("high-performance-java-persistence"));
            return null;
        });
        Post post = (Post)this.transactionTemplate.execute(transactionStatus -> (Post)this.postRepository.getReferenceById(1L));
        Assert.assertEquals((Object)1L, (Object)post.getId());
        try {
            post.getTitle();
            Assert.fail((String)"Should have thrown LazyInitializationException");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

