/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.spring.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.hypersistence.utils.hibernate.util.logging.InlineQueryLogEntryCreator;
import io.hypersistence.utils.hibernate.util.providers.DataSourceProvider;
import io.hypersistence.utils.hibernate.util.providers.PostgreSQLDataSourceProvider;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.spi.PersistenceProvider;
import java.util.Properties;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.listener.logging.QueryLogEntryCreator;
import net.ttddyy.dsproxy.listener.logging.SLF4JQueryLoggingListener;
import net.ttddyy.dsproxy.support.ProxyDataSource;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.support.TransactionTemplate;

@Configuration
@EnableTransactionManagement
@EnableAspectJAutoProxy
public abstract class AbstractSpringDataJPAConfiguration {
    private DataSourceProvider dataSourceProvider = new PostgreSQLDataSourceProvider();

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySources() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean(destroyMethod="close")
    public HikariDataSource actualDataSource() {
        Properties properties = new Properties();
        properties.setProperty("maximumPoolSize", String.valueOf(3));
        HikariConfig hikariConfig = new HikariConfig(properties);
        hikariConfig.setAutoCommit(false);
        hikariConfig.setDataSource(this.dataSourceProvider.dataSource());
        return new HikariDataSource(hikariConfig);
    }

    @Bean
    public DataSource dataSource() {
        SLF4JQueryLoggingListener loggingListener = new SLF4JQueryLoggingListener();
        loggingListener.setQueryLogEntryCreator((QueryLogEntryCreator)new InlineQueryLogEntryCreator());
        ProxyDataSource dataSource = ProxyDataSourceBuilder.create((DataSource)this.actualDataSource()).name("DATA_SOURCE_PROXY").listener((QueryExecutionListener)loggingListener).build();
        return dataSource;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory() {
        LocalContainerEntityManagerFactoryBean entityManagerFactoryBean = new LocalContainerEntityManagerFactoryBean();
        entityManagerFactoryBean.setPersistenceUnitName(this.getClass().getSimpleName());
        entityManagerFactoryBean.setPersistenceProvider((PersistenceProvider)new HibernatePersistenceProvider());
        entityManagerFactoryBean.setDataSource(this.dataSource());
        entityManagerFactoryBean.setPackagesToScan(this.packagesToScan());
        HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
        entityManagerFactoryBean.setJpaVendorAdapter((JpaVendorAdapter)vendorAdapter);
        entityManagerFactoryBean.setJpaProperties(this.properties());
        return entityManagerFactoryBean;
    }

    @Bean
    public JpaTransactionManager transactionManager(EntityManagerFactory entityManagerFactory) {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(entityManagerFactory);
        return transactionManager;
    }

    @Bean
    public TransactionTemplate transactionTemplate(EntityManagerFactory entityManagerFactory) {
        return new TransactionTemplate((PlatformTransactionManager)this.transactionManager(entityManagerFactory));
    }

    @Bean
    public JdbcTemplate jdbcTemplate(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    protected Properties properties() {
        Properties properties = new Properties();
        properties.setProperty("hibernate.dialect", this.dataSourceProvider.hibernateDialect());
        properties.setProperty("hibernate.hbm2ddl.auto", "create-drop");
        this.additionalProperties(properties);
        return properties;
    }

    protected void additionalProperties(Properties properties) {
    }

    protected String[] packagesToScan() {
        return new String[]{this.packageToScan()};
    }

    protected String packageToScan() {
        return "io.hypersistence.utils.spring.domain";
    }
}

