/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.spring.aop;

import io.hypersistence.utils.spring.aop.RetryAspectConfiguration;
import io.hypersistence.utils.spring.aop.service.CustomerService;
import io.hypersistence.utils.spring.aop.service.ItemService;
import io.hypersistence.utils.spring.aop.service.ProductService;
import jakarta.persistence.OptimisticLockException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@ContextConfiguration(classes={RetryAspectConfiguration.class})
public class RetryAspectTest {
    @Autowired
    private ProductService productService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    private ItemService itemService;

    @Before
    public void before() {
        this.productService.resetCalls();
        this.customerService.resetCalls();
        this.itemService.resetCalls();
    }

    @Test
    @Ignore(value="https://github.com/spring-projects/spring-framework/issues/22311")
    public void testRetryOnInterface() {
        Assert.assertEquals((long)0L, (long)this.productService.getCalls());
        try {
            this.productService.saveProduct();
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)this.productService.getCalls());
    }

    @Test
    public void testRetryOnImplementation() {
        Assert.assertEquals((long)0L, (long)this.customerService.getCalls());
        try {
            this.customerService.saveCustomer();
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)this.customerService.getCalls());
    }

    @Test
    public void testRetryOnImplementationWithArgs() {
        Assert.assertEquals((long)0L, (long)this.customerService.getCalls());
        try {
            this.customerService.saveCustomer("User A", "client");
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)this.customerService.getCalls());
    }

    @Test
    public void testRetryOnImplementationWithNullArg() {
        Assert.assertEquals((long)0L, (long)this.customerService.getCalls());
        try {
            this.customerService.saveCustomer("Unknown user", null);
        }
        catch (OptimisticLockException optimisticLockException) {
            // empty catch block
        }
        Assert.assertEquals((long)3L, (long)this.customerService.getCalls());
    }
}

