/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.util.providers;

import io.hypersistence.utils.hibernate.util.providers.AbstractContainerDataSourceProvider;
import io.hypersistence.utils.hibernate.util.providers.Database;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorNoOpImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.testcontainers.containers.JdbcDatabaseContainer;

public class OracleDataSourceProvider
extends AbstractContainerDataSourceProvider {
    @Override
    public String hibernateDialect() {
        return FastOracleDialect.class.getName();
    }

    @Override
    public String defaultJdbcUrl() {
        return "jdbc:oracle:thin:@localhost:1521/xe";
    }

    @Override
    public DataSource newDataSource() {
        try {
            OracleDataSource dataSource = new OracleDataSource();
            JdbcDatabaseContainer container = this.database().getContainer();
            if (container == null) {
                dataSource.setDatabaseName("high_performance_java_persistence");
            } else {
                dataSource.setDatabaseName(container.getDatabaseName());
            }
            dataSource.setURL(this.url());
            dataSource.setUser(this.username());
            dataSource.setPassword(this.password());
            return dataSource;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String username() {
        return "oracle";
    }

    @Override
    public String password() {
        return "admin";
    }

    @Override
    public Database database() {
        return Database.ORACLE;
    }

    public static class FastOracleDialect
    extends OracleDialect {
        public SequenceInformationExtractor getSequenceInformationExtractor() {
            return SequenceInformationExtractorNoOpImpl.INSTANCE;
        }
    }
}

