/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.util.providers;

import com.mysql.cj.jdbc.MysqlDataSource;
import io.hypersistence.utils.hibernate.util.providers.AbstractContainerDataSourceProvider;
import io.hypersistence.utils.hibernate.util.providers.Database;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.hibernate.dialect.MySQLDialect;

public class MySQLDataSourceProvider
extends AbstractContainerDataSourceProvider {
    private boolean rewriteBatchedStatements = true;
    private boolean cachePrepStmts = false;
    private boolean useServerPrepStmts = false;
    private boolean useTimezone = false;
    private boolean useJDBCCompliantTimezoneShift = false;
    private boolean useLegacyDatetimeCode = true;

    public boolean isRewriteBatchedStatements() {
        return this.rewriteBatchedStatements;
    }

    public void setRewriteBatchedStatements(boolean rewriteBatchedStatements) {
        this.rewriteBatchedStatements = rewriteBatchedStatements;
    }

    public boolean isCachePrepStmts() {
        return this.cachePrepStmts;
    }

    public void setCachePrepStmts(boolean cachePrepStmts) {
        this.cachePrepStmts = cachePrepStmts;
    }

    public boolean isUseServerPrepStmts() {
        return this.useServerPrepStmts;
    }

    public void setUseServerPrepStmts(boolean useServerPrepStmts) {
        this.useServerPrepStmts = useServerPrepStmts;
    }

    public boolean isUseTimezone() {
        return this.useTimezone;
    }

    public void setUseTimezone(boolean useTimezone) {
        this.useTimezone = useTimezone;
    }

    public boolean isUseJDBCCompliantTimezoneShift() {
        return this.useJDBCCompliantTimezoneShift;
    }

    public void setUseJDBCCompliantTimezoneShift(boolean useJDBCCompliantTimezoneShift) {
        this.useJDBCCompliantTimezoneShift = useJDBCCompliantTimezoneShift;
    }

    public boolean isUseLegacyDatetimeCode() {
        return this.useLegacyDatetimeCode;
    }

    public void setUseLegacyDatetimeCode(boolean useLegacyDatetimeCode) {
        this.useLegacyDatetimeCode = useLegacyDatetimeCode;
    }

    @Override
    public String hibernateDialect() {
        return MySQLDialect.class.getName();
    }

    @Override
    protected String defaultJdbcUrl() {
        return "jdbc:mysql://localhost/high_performance_java_persistence?useSSL=false";
    }

    @Override
    protected DataSource newDataSource() {
        try {
            MysqlDataSource dataSource = new MysqlDataSource();
            dataSource.setURL(this.url());
            dataSource.setUser(this.username());
            dataSource.setPassword(this.password());
            dataSource.setRewriteBatchedStatements(this.rewriteBatchedStatements);
            dataSource.setCachePrepStmts(this.cachePrepStmts);
            dataSource.setUseServerPrepStmts(this.useServerPrepStmts);
            return dataSource;
        }
        catch (SQLException e) {
            throw new IllegalStateException("The DataSource could not be instantiated!");
        }
    }

    @Override
    public String username() {
        return "mysql";
    }

    @Override
    public String password() {
        return "admin";
    }

    @Override
    public Database database() {
        return Database.MYSQL;
    }

    public String toString() {
        return "MySQLDataSourceProvider{rewriteBatchedStatements=" + this.rewriteBatchedStatements + ", cachePrepStmts=" + this.cachePrepStmts + ", useServerPrepStmts=" + this.useServerPrepStmts + ", useTimezone=" + this.useTimezone + ", useJDBCCompliantTimezoneShift=" + this.useJDBCCompliantTimezoneShift + ", useLegacyDatetimeCode=" + this.useLegacyDatetimeCode + "}";
    }
}

