/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.util.providers;

import io.hypersistence.utils.hibernate.util.providers.DataSourceProvider;
import io.hypersistence.utils.hibernate.util.providers.Database;
import javax.sql.DataSource;
import org.hibernate.dialect.HSQLDialect;
import org.hsqldb.jdbc.JDBCDataSource;

public class HSQLDBDataSourceProvider
implements DataSourceProvider {
    @Override
    public String hibernateDialect() {
        return HSQLDialect.class.getName();
    }

    @Override
    public DataSource dataSource() {
        JDBCDataSource dataSource = new JDBCDataSource();
        dataSource.setUrl(this.url());
        dataSource.setUser(this.username());
        dataSource.setPassword(this.password());
        return dataSource;
    }

    @Override
    public String url() {
        return "jdbc:hsqldb:mem:test";
    }

    @Override
    public String username() {
        return "sa";
    }

    @Override
    public String password() {
        return "";
    }

    @Override
    public Database database() {
        return Database.HSQLDB;
    }
}

