/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.util.providers;

import io.hypersistence.utils.hibernate.util.providers.DataSourceProvider;
import io.hypersistence.utils.hibernate.util.providers.Database;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcConnectionPool;
import org.hibernate.dialect.H2Dialect;

public class H2DataSourceProvider
implements DataSourceProvider {
    @Override
    public String hibernateDialect() {
        return H2Dialect.class.getName();
    }

    @Override
    public DataSource dataSource() {
        return JdbcConnectionPool.create((String)this.url(), (String)this.username(), (String)this.password());
    }

    @Override
    public String url() {
        return "jdbc:h2:mem:test";
    }

    @Override
    public String username() {
        return "sa";
    }

    @Override
    public String password() {
        return "";
    }

    @Override
    public Database database() {
        return Database.H2;
    }
}

