/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.util.providers;

import java.util.Collections;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.MSSQLServerContainer;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.containers.PostgreSQLContainer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Database {
    POSTGRESQL{

        @Override
        protected JdbcDatabaseContainer newJdbcDatabaseContainer() {
            return new PostgreSQLContainer("postgres:13.7");
        }
    }
    ,
    ORACLE{

        @Override
        protected JdbcDatabaseContainer newJdbcDatabaseContainer() {
            return new OracleContainer("gvenzl/oracle-xe:21.3.0-slim");
        }

        @Override
        protected boolean supportsDatabaseName() {
            return false;
        }
    }
    ,
    MYSQL{

        @Override
        protected JdbcDatabaseContainer newJdbcDatabaseContainer() {
            return new MySQLContainer("mysql:8.0");
        }
    }
    ,
    SQLSERVER{

        @Override
        protected JdbcDatabaseContainer newJdbcDatabaseContainer() {
            return new MSSQLServerContainer("mcr.microsoft.com/mssql/server:2019-latest");
        }

        @Override
        protected boolean supportsDatabaseName() {
            return false;
        }

        @Override
        protected boolean supportsCredentials() {
            return false;
        }
    }
    ,
    HSQLDB,
    H2;

    private JdbcDatabaseContainer container;

    public JdbcDatabaseContainer getContainer() {
        return this.container;
    }

    public void initContainer(String username, String password) {
        this.container = (JdbcDatabaseContainer)this.newJdbcDatabaseContainer().withReuse(true).withEnv(Collections.singletonMap("ACCEPT_EULA", "Y")).withTmpFs(Collections.singletonMap("/testtmpfs", "rw"));
        if (this.supportsDatabaseName()) {
            this.container.withDatabaseName("high-performance-java-persistence");
        }
        if (this.supportsCredentials()) {
            this.container.withUsername(username).withPassword(password);
        }
        this.container.start();
    }

    protected JdbcDatabaseContainer newJdbcDatabaseContainer() {
        throw new UnsupportedOperationException(String.format("The [%s] database was not configured to use Testcontainers!", this.name()));
    }

    protected boolean supportsDatabaseName() {
        return true;
    }

    protected boolean supportsCredentials() {
        return true;
    }
}

