/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Lists;
import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperJsonSerializer;
import io.hypersistence.utils.hibernate.type.util.ObjectMapperWrapper;
import jakarta.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class ObjectMapperJsonSerializerTest {
    private ObjectMapperWrapper mapper = new ObjectMapperWrapper();
    private ObjectMapperJsonSerializer serializer = new ObjectMapperJsonSerializer(this.mapper);

    @Test
    public void should_clone_serializable_object() {
        SerializableObject original = new SerializableObject("value");
        Object cloned = this.serializer.clone((Object)original);
        Assert.assertEquals((Object)original, (Object)cloned);
        Assert.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void should_clone_non_serializable_object() {
        NonSerializableObject original = new NonSerializableObject("value");
        Object cloned = this.serializer.clone((Object)original);
        Assert.assertEquals((Object)original, (Object)cloned);
        Assert.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void should_clone_collection_of_serializable_object() {
        ArrayList<SerializableObject> original = new ArrayList<SerializableObject>();
        original.add(new SerializableObject("value"));
        List cloned = (List)this.serializer.clone(original);
        Assert.assertEquals(original, (Object)cloned);
        Assert.assertNotSame(original, (Object)cloned);
    }

    @Test
    public void should_clone_collection_of_non_serializable_object() {
        ArrayList<NonSerializableObject> original = new ArrayList<NonSerializableObject>();
        original.add(new NonSerializableObject("value"));
        List cloned = (List)this.serializer.clone(original);
        Assert.assertEquals(original, (Object)cloned);
        Assert.assertNotSame(original, (Object)cloned);
    }

    @Test
    public void should_clone_empty_collection() {
        ArrayList original = new ArrayList();
        Object cloned = this.serializer.clone(original);
        Assert.assertEquals(original, (Object)cloned);
        Assert.assertNotSame(original, (Object)cloned);
    }

    @Test
    public void should_clone_map_of_non_serializable_key() {
        HashMap<NonSerializableObject, String> original = new HashMap<NonSerializableObject, String>();
        original.put(new NonSerializableObject("key"), "value");
        Object cloned = this.serializer.clone(original);
        Assert.assertEquals(original, (Object)cloned);
        Assert.assertNotSame(original, (Object)cloned);
    }

    @Test
    public void should_clone_map_of_non_serializable_value() {
        HashMap<String, NonSerializableObject> original = new HashMap<String, NonSerializableObject>();
        original.put("key", new NonSerializableObject("value"));
        Object cloned = this.serializer.clone(original);
        Assert.assertEquals(original, (Object)cloned);
        Assert.assertNotSame(original, (Object)cloned);
    }

    @Test
    public void should_clone_map_of_serializable_key_and_value() {
        HashMap<String, SerializableObject> original = new HashMap<String, SerializableObject>();
        original.put("key", new SerializableObject("value"));
        Object cloned = this.serializer.clone(original);
        Assert.assertEquals(original, (Object)cloned);
        Assert.assertNotSame(original, (Object)cloned);
    }

    @Test
    public void should_clone_map_with_null_value() {
        HashMap<String, Object> original = new HashMap<String, Object>();
        original.put("null", null);
        Object cloned = this.serializer.clone(original);
        Assert.assertEquals(original, (Object)cloned);
        Assert.assertNotSame(original, (Object)cloned);
    }

    @Test
    public void should_clone_map_of_non_serializable_value_with_null_value() {
        LinkedHashMap<String, NonSerializableObject> original = new LinkedHashMap<String, NonSerializableObject>();
        original.put("null", null);
        original.put("key", new NonSerializableObject("value"));
        Object cloned = this.serializer.clone(original);
        Assert.assertEquals(original, (Object)cloned);
        Assert.assertNotSame(original, (Object)cloned);
    }

    @Test
    public void should_clone_map_of_serializable_key_and_value_with_null() {
        LinkedHashMap<String, SerializableObject> original = new LinkedHashMap<String, SerializableObject>();
        original.put("null", null);
        original.put("key", new SerializableObject("value"));
        Object cloned = this.serializer.clone(original);
        Assert.assertEquals(original, (Object)cloned);
        Assert.assertNotSame(original, (Object)cloned);
    }

    @Test
    public void should_clone_serializable_complex_object_with_serializable_nested_object() {
        LinkedHashMap<String, List<SerializableObject>> map = new LinkedHashMap<String, List<SerializableObject>>();
        map.put("key1", Lists.newArrayList((Object[])new SerializableObject[]{new SerializableObject("name1")}));
        map.put("key2", Lists.newArrayList((Object[])new SerializableObject[]{new SerializableObject("name2"), new SerializableObject("name3")}));
        SerializableComplexObject original = new SerializableComplexObject(map);
        Object cloned = this.serializer.clone((Object)original);
        Assert.assertEquals((Object)original, (Object)cloned);
        Assert.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void should_clone_serializable_complex_object_with_non_serializable_nested_object() {
        LinkedHashMap<String, List<NonSerializableObject>> map = new LinkedHashMap<String, List<NonSerializableObject>>();
        map.put("key1", Lists.newArrayList((Object[])new NonSerializableObject[]{new NonSerializableObject("name1")}));
        map.put("key2", Lists.newArrayList((Object[])new NonSerializableObject[]{new NonSerializableObject("name2"), new NonSerializableObject("name3")}));
        SerializableComplexObjectWithNonSerializableNestedObject original = new SerializableComplexObjectWithNonSerializableNestedObject(map);
        Object cloned = this.serializer.clone((Object)original);
        Assert.assertEquals((Object)original, (Object)cloned);
        Assert.assertNotSame((Object)original, (Object)cloned);
    }

    @Test
    public void should_clone_jsonnode() {
        ArrayNode original = this.mapper.getObjectMapper().createArrayNode().add(BigDecimal.ONE).add(1.0).add("string");
        Object cloned = this.serializer.clone((Object)original);
        Assert.assertEquals((Object)original, (Object)cloned);
        Assert.assertNotSame((Object)original, (Object)cloned);
    }

    private static class SerializableObject
    implements Serializable {
        private final String value;

        private SerializableObject(@JsonProperty(value="value") String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializableObject that = (SerializableObject)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }

    private static class NonSerializableObject {
        private final String value;

        private NonSerializableObject(@JsonProperty(value="value") String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NonSerializableObject that = (NonSerializableObject)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }

    private static class SerializableComplexObject
    implements Serializable {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private final Map<String, List<SerializableObject>> value;

        private SerializableComplexObject(@JsonProperty(value="value") Map<String, List<SerializableObject>> value) {
            this.value = value;
        }

        public Map<String, List<SerializableObject>> getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializableComplexObject that = (SerializableComplexObject)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static class SerializableComplexObjectWithNonSerializableNestedObject
    implements Serializable {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private final Map<String, List<NonSerializableObject>> value;

        private SerializableComplexObjectWithNonSerializableNestedObject(@JsonProperty(value="value") Map<String, List<NonSerializableObject>> value) {
            this.value = value;
        }

        public Map<String, List<NonSerializableObject>> getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SerializableComplexObjectWithNonSerializableNestedObject that = (SerializableComplexObjectWithNonSerializableNestedObject)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

