/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.search;

import io.hypersistence.utils.hibernate.type.search.PostgreSQLTSVectorType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLTSVectorTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setId(1L);
            book.setIsbn("978-9730228236");
            book.setFts("This book is a journey into Java data access performance tuning. From connection management, to batch updates, fetch sizes and concurrency control mechanisms, it unravels the inner workings of the most common Java data access frameworks.");
            entityManager.persist((Object)book);
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)entityManager.find(Book.class, (Object)1L);
            Assert.assertTrue((boolean)book.getFts().contains("Java"));
            Assert.assertTrue((boolean)book.getFts().contains("concurrency"));
            Assert.assertTrue((boolean)book.getFts().contains("book"));
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        private Long id;
        @NaturalId
        private String isbn;
        @Type(value=PostgreSQLTSVectorType.class)
        @Column(columnDefinition="tsvector")
        private String fts;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getIsbn() {
            return this.isbn;
        }

        public void setIsbn(String isbn) {
            this.isbn = isbn;
        }

        public String getFts() {
            return this.fts;
        }

        public void setFts(String fts) {
            this.fts = fts;
        }
    }
}

