/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.range.guava;

import com.google.common.collect.Range;
import io.hypersistence.utils.hibernate.type.range.guava.PostgreSQLGuavaRangeType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLGuavaRangeTypeTest
extends AbstractPostgreSQLIntegrationTest {
    private static final ZoneOffset DEFAULT_OFFSET = OffsetDateTime.now().getOffset();
    private final Range<BigDecimal> numeric = Range.closedOpen((Comparable)new BigDecimal("0.5"), (Comparable)new BigDecimal("0.89"));
    private final Range<Long> int8Range = Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(18L));
    private final Range<Integer> int4Range = Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(18));
    private final Range<LocalDateTime> localDateTimeRange = Range.closed((Comparable)LocalDateTime.of(2014, Month.APRIL, 28, 16, 0, 49), (Comparable)LocalDateTime.of(2015, Month.APRIL, 28, 16, 0, 49));
    private final Range<ZonedDateTime> tsTz = Range.closed((Comparable)OffsetDateTime.of(LocalDateTime.of(2007, Month.DECEMBER, 3, 10, 15, 30), ZoneOffset.ofHours(1)).toZonedDateTime(), (Comparable)OffsetDateTime.of(LocalDateTime.of(2008, Month.DECEMBER, 3, 10, 15, 30), ZoneOffset.ofHours(1)).toZonedDateTime());
    private final Range<OffsetDateTime> tsTzO = Range.closed((Comparable)OffsetDateTime.of(LocalDateTime.of(2007, Month.MAY, 3, 10, 15, 30), DEFAULT_OFFSET), (Comparable)OffsetDateTime.of(LocalDateTime.of(2008, Month.MAY, 3, 10, 15, 30), DEFAULT_OFFSET));
    private final Range<LocalDate> dateRange = Range.closedOpen((Comparable)LocalDate.of(1992, Month.JANUARY, 13), (Comparable)LocalDate.of(1995, Month.JANUARY, 13));

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Restriction.class};
    }

    @Test
    public void test() {
        Restriction ageRestrictionInt = (Restriction)this.doInJPA(entityManager -> {
            entityManager.persist((Object)new Restriction());
            Restriction restriction = new Restriction();
            restriction.setRangeInt(this.int4Range);
            restriction.setRangeLong(this.int8Range);
            restriction.setRangeBigDecimal(this.numeric);
            restriction.setRangeLocalDateTime(this.localDateTimeRange);
            restriction.setRangeZonedDateTime(this.tsTz);
            restriction.setLocalDateRange(this.dateRange);
            restriction.setOffsetZonedDateTime(this.tsTzO);
            entityManager.persist((Object)restriction);
            return restriction;
        });
        this.doInJPA(entityManager -> {
            Restriction ar = (Restriction)entityManager.find(Restriction.class, (Object)ageRestrictionInt.getId());
            Assert.assertEquals(this.int4Range, ar.getRangeInt());
            Assert.assertEquals(this.int8Range, ar.getRangeLong());
            Assert.assertEquals(this.numeric, ar.getRangeBigDecimal());
            Assert.assertEquals(this.localDateTimeRange, ar.getLocalDateTimeRange());
            Assert.assertEquals(this.dateRange, ar.getLocalDateRange());
            ZoneId zone = ((ZonedDateTime)ar.getRangeZonedDateTime().lowerEndpoint()).getZone();
            ZonedDateTime lower = ((ZonedDateTime)this.tsTz.lowerEndpoint()).withZoneSameInstant(zone);
            ZonedDateTime upper = ((ZonedDateTime)this.tsTz.upperEndpoint()).withZoneSameInstant(zone);
            Assert.assertEquals(ar.getRangeZonedDateTime(), (Object)Range.closed((Comparable)lower, (Comparable)upper));
        });
    }

    @Test
    public void testNullRange() {
        Restriction ageRestrictionInt = (Restriction)this.doInJPA(entityManager -> {
            Restriction restriction = new Restriction();
            entityManager.persist((Object)restriction);
            return restriction;
        });
        this.doInJPA(entityManager -> {
            Restriction ar = (Restriction)entityManager.find(Restriction.class, (Object)ageRestrictionInt.getId());
            Assert.assertNull(ar.getRangeInt());
            Assert.assertNull(ar.getRangeLong());
            Assert.assertNull(ar.getRangeBigDecimal());
            Assert.assertNull(ar.getLocalDateTimeRange());
            Assert.assertNull(ar.getLocalDateRange());
            Assert.assertNull(ar.getRangeZonedDateTime());
        });
    }

    @Test
    public void testUnboundedRangeIsRejected() {
        Restriction ageRestrictionInt = (Restriction)this.doInJPA(entityManager -> {
            Restriction restriction = new Restriction();
            restriction.setRangeInt((Range<Integer>)Range.all());
            entityManager.persist((Object)restriction);
            return restriction;
        });
        this.doInJPA(entityManager -> {
            Restriction ar = (Restriction)entityManager.find(Restriction.class, (Object)ageRestrictionInt.getId());
            Assert.assertEquals(ar.getRangeInt(), (Object)Range.all());
        });
    }

    @Test
    public void testUnboundedRangeStringIsRejected() {
        PostgreSQLGuavaRangeType instance = PostgreSQLGuavaRangeType.INSTANCE;
        Assert.assertEquals((Object)Range.all(), (Object)PostgreSQLGuavaRangeType.integerRange((String)"(,)"));
    }

    @Test
    public void testSingleBoundedRanges() {
        PostgreSQLGuavaRangeType instance = PostgreSQLGuavaRangeType.INSTANCE;
        Assert.assertEquals((Object)"(,)", (Object)instance.asString(Range.all()));
        Assert.assertEquals((Object)"(1,)", (Object)instance.asString(Range.greaterThan((Comparable)Integer.valueOf(1))));
        Assert.assertEquals((Object)"[2,)", (Object)instance.asString(Range.atLeast((Comparable)Integer.valueOf(2))));
        Assert.assertEquals((Object)"(,3)", (Object)instance.asString(Range.lessThan((Comparable)Integer.valueOf(3))));
        Assert.assertEquals((Object)"(,4]", (Object)instance.asString(Range.atMost((Comparable)Integer.valueOf(4))));
        Assert.assertEquals((Object)Range.greaterThan((Comparable)Integer.valueOf(5)), (Object)PostgreSQLGuavaRangeType.integerRange((String)"(5,)"));
        Assert.assertEquals((Object)Range.atLeast((Comparable)Integer.valueOf(6)), (Object)PostgreSQLGuavaRangeType.integerRange((String)"[6,)"));
        Assert.assertEquals((Object)Range.lessThan((Comparable)Integer.valueOf(7)), (Object)PostgreSQLGuavaRangeType.integerRange((String)"(,7)"));
        Assert.assertEquals((Object)Range.atMost((Comparable)Integer.valueOf(8)), (Object)PostgreSQLGuavaRangeType.integerRange((String)"(,8]"));
    }

    @Entity(name="AgeRestriction")
    @Table(name="age_restriction")
    public static class Restriction {
        @Id
        @GeneratedValue
        private Long id;
        @Type(value=PostgreSQLGuavaRangeType.class)
        @Column(name="r_int", columnDefinition="int4Range")
        private Range<Integer> rangeInt;
        @Type(value=PostgreSQLGuavaRangeType.class)
        @Column(name="r_long", columnDefinition="int8range")
        private Range<Long> rangeLong;
        @Type(value=PostgreSQLGuavaRangeType.class)
        @Column(name="r_numeric", columnDefinition="numrange")
        private Range<BigDecimal> rangeBigDecimal;
        @Type(value=PostgreSQLGuavaRangeType.class)
        @Column(name="r_tsrange", columnDefinition="tsrange")
        private Range<LocalDateTime> rangeLocalDateTime;
        @Type(value=PostgreSQLGuavaRangeType.class)
        @Column(name="r_tstzrange", columnDefinition="tstzrange")
        private Range<ZonedDateTime> rangeZonedDateTime;
        @Type(value=PostgreSQLGuavaRangeType.class)
        @Column(name="r_otstzrange", columnDefinition="tstzrange")
        private Range<OffsetDateTime> offsetZonedDateTime;
        @Type(value=PostgreSQLGuavaRangeType.class)
        @Column(name="r_daterange", columnDefinition="daterange")
        private Range<LocalDate> localDateRange;

        public Long getId() {
            return this.id;
        }

        public Range<Long> getRangeLong() {
            return this.rangeLong;
        }

        public void setRangeLong(Range<Long> rangeLong) {
            this.rangeLong = rangeLong;
        }

        public Range<Integer> getRangeInt() {
            return this.rangeInt;
        }

        public void setRangeInt(Range<Integer> rangeInt) {
            this.rangeInt = rangeInt;
        }

        public Range<BigDecimal> getRangeBigDecimal() {
            return this.rangeBigDecimal;
        }

        public void setRangeBigDecimal(Range<BigDecimal> rangeBigDecimal) {
            this.rangeBigDecimal = rangeBigDecimal;
        }

        public Range<LocalDateTime> getLocalDateTimeRange() {
            return this.rangeLocalDateTime;
        }

        public void setRangeLocalDateTime(Range<LocalDateTime> rangeLocalDateTime) {
            this.rangeLocalDateTime = rangeLocalDateTime;
        }

        public Range<ZonedDateTime> getRangeZonedDateTime() {
            return this.rangeZonedDateTime;
        }

        public void setRangeZonedDateTime(Range<ZonedDateTime> rangeZonedDateTime) {
            this.rangeZonedDateTime = rangeZonedDateTime;
        }

        public Range<LocalDate> getLocalDateRange() {
            return this.localDateRange;
        }

        public void setLocalDateRange(Range<LocalDate> localDateRange) {
            this.localDateRange = localDateRange;
        }

        public Range<OffsetDateTime> getOffsetZonedDateTime() {
            return this.offsetZonedDateTime;
        }

        public void setOffsetZonedDateTime(Range<OffsetDateTime> offsetZonedDateTime) {
            this.offsetZonedDateTime = offsetZonedDateTime;
        }
    }
}

