/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.range;

import io.hypersistence.utils.hibernate.type.range.PostgreSQLRangeType;
import io.hypersistence.utils.hibernate.type.range.Range;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class ZonedDateTimeMilliSecondTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Restriction.class};
    }

    @Test
    public void test() {
        this.validateTest((Range<ZonedDateTime>)Range.zonedDateTimeRange((String)"[\"2018-05-03T10:15:30.127110+12:00\",\"2018-12-03T10:15:30.127111+12:00\"]"));
        this.validateTest((Range<ZonedDateTime>)Range.zonedDateTimeRange((String)"[\"2018-05-03T10:15:30.127100+12:00\",\"2018-12-03T10:15:30.127111+12:00\"]"));
        this.validateTest((Range<ZonedDateTime>)Range.zonedDateTimeRange((String)"[\"2018-05-03T10:15:30.127000+12:00\",\"2018-12-03T10:15:30.127111+12:00\"]"));
    }

    private void validateTest(Range<ZonedDateTime> tsTz) {
        Restriction _restriction = (Restriction)this.doInJPA(entityManager -> {
            Restriction restriction = new Restriction();
            restriction.setRangeZonedDateTime(tsTz);
            entityManager.persist((Object)restriction);
            return restriction;
        });
        this.doInJPA(entityManager -> {
            Restriction restriction = (Restriction)entityManager.find(Restriction.class, (Object)_restriction.getId());
            ZoneId zone = ((ZonedDateTime)restriction.getRangeZonedDateTime().lower()).getZone();
            ZonedDateTime lower = ((ZonedDateTime)tsTz.lower()).withZoneSameInstant(zone);
            Assert.assertEquals((Object)lower, (Object)restriction.getRangeZonedDateTime().lower());
            Assert.assertEquals((Object)LocalDateTime.parse("2018-12-03T10:15:30").atZone(ZoneId.systemDefault()).getOffset(), (Object)((ZonedDateTime)restriction.getRangeZonedDateTime().upper()).getOffset());
        });
    }

    @Entity(name="AgeRestriction")
    @Table(name="age_restriction")
    public static class Restriction {
        @Id
        @GeneratedValue
        private Long id;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_tstzrange", columnDefinition="tstzrange")
        private Range<ZonedDateTime> rangeZonedDateTime;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Range<ZonedDateTime> getRangeZonedDateTime() {
            return this.rangeZonedDateTime;
        }

        public void setRangeZonedDateTime(Range<ZonedDateTime> rangeZonedDateTime) {
            this.rangeZonedDateTime = rangeZonedDateTime;
        }
    }
}

