/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.range;

import io.hypersistence.utils.hibernate.type.range.Range;
import java.time.LocalDate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class RangeTest {
    @Test
    public void ofStringTest() {
        Assert.assertThat((Object)((Integer)Range.integerRange((String)"[1,3]").lower()), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Integer)Range.integerRange((String)"[1,3]").upper()), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)Range.integerRange((String)"[1,3]").isUpperBoundClosed(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"[1,3]").isLowerBoundClosed(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Integer)Range.integerRange((String)"[,3]").lower()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Integer)Range.integerRange((String)"[,3]").upper()), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)Range.integerRange((String)"[,3]").hasLowerBound(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Range.integerRange((String)"[,3]").hasUpperBound(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"[,3]").isUpperBoundClosed(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"[,3]").isLowerBoundClosed(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Integer)Range.integerRange((String)"[,]").lower()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)((Integer)Range.integerRange((String)"[,]").upper()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)Range.integerRange((String)"[,]").hasLowerBound(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Range.integerRange((String)"[,]").hasUpperBound(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Range.integerRange((String)"[,]").isUpperBoundClosed(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Range.integerRange((String)"[,]").isLowerBoundClosed(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Range.integerRange((String)"(-5,5]").isUpperBoundClosed(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"(-5,5]").isLowerBoundClosed(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)Range.integerRange((String)"(,)").contains(Range.integerRange((String)"empty")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"empty").contains(Range.integerRange((String)"(,)")), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void containsRange() {
        Assert.assertThat((Object)Range.integerRange((String)"[-5,5]").contains(Range.integerRange((String)"[-4,4]")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"[-5,5]").contains(Range.integerRange((String)"[-5,5]")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"(-5,5]").contains(Range.integerRange((String)"[-4,4]")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"(-5,5]").contains(Range.integerRange((String)"(-4,4]")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"(,)").contains(Range.integerRange((String)"(,)")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"(5,)").contains(Range.integerRange((String)"(6,)")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"(,5)").contains(Range.integerRange((String)"(,4)")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"(,)").contains(Range.integerRange((String)"(6,)")), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)Range.integerRange((String)"(,)").contains(Range.integerRange((String)"(,6)")), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void localDateTimeTest() {
        Assert.assertNotNull((Object)Range.localDateTimeRange((String)"[2019-03-27 16:33:10.1,)"));
        Assert.assertNotNull((Object)Range.localDateTimeRange((String)"[2019-03-27 16:33:10.12,)"));
        Assert.assertNotNull((Object)Range.localDateTimeRange((String)"[2019-03-27 16:33:10.123,)"));
        Assert.assertNotNull((Object)Range.localDateTimeRange((String)"[2019-03-27 16:33:10.1234,)"));
        Assert.assertNotNull((Object)Range.localDateTimeRange((String)"[2019-03-27 16:33:10.12345,)"));
        Assert.assertNotNull((Object)Range.localDateTimeRange((String)"[2019-03-27 16:33:10.123456,)"));
        Assert.assertNotNull((Object)Range.localDateTimeRange((String)"[2019-03-27 16:33:10.123456,infinity)"));
    }

    @Test
    public void zonedDateTimeTest() {
        Assert.assertNotNull((Object)Range.zonedDateTimeRange((String)"[2019-03-27 16:33:10.1-06,)"));
        Assert.assertNotNull((Object)Range.zonedDateTimeRange((String)"[2019-03-27 16:33:10.12-06,)"));
        Assert.assertNotNull((Object)Range.zonedDateTimeRange((String)"[2019-03-27 16:33:10.123-06,)"));
        Assert.assertNotNull((Object)Range.zonedDateTimeRange((String)"[2019-03-27 16:33:10.1234-06,)"));
        Assert.assertNotNull((Object)Range.zonedDateTimeRange((String)"[2019-03-27 16:33:10.12345-06,)"));
        Assert.assertNotNull((Object)Range.zonedDateTimeRange((String)"[2019-03-27 16:33:10.123456-06,)"));
        Assert.assertNotNull((Object)Range.zonedDateTimeRange((String)"[2019-03-27 16:33:10.123456+05:30,)"));
        Assert.assertNotNull((Object)Range.zonedDateTimeRange((String)"[2019-03-27 16:33:10.123456-06,infinity)"));
    }

    @Test
    public void emptyInfinityEquality() {
        Assert.assertEquals((Object)Range.integerRange((String)"empty"), (Object)Range.integerRange((String)"empty"));
        Assert.assertEquals((Object)Range.integerRange((String)"(infinity,infinity)"), (Object)Range.integerRange((String)"(infinity,infinity)"));
        Assert.assertEquals((Object)Range.integerRange((String)"(,)"), (Object)Range.integerRange((String)"(infinity,infinity)"));
        Assert.assertEquals((Object)Range.integerRange((String)"(infinity,infinity)"), (Object)Range.integerRange((String)"(,)"));
        Assert.assertNotEquals((Object)Range.integerRange((String)"empty"), (Object)Range.integerRange((String)"(infinity,infinity)"));
        Assert.assertNotEquals((Object)Range.integerRange((String)"empty"), (Object)Range.integerRange((String)"(,)"));
        Assert.assertNotEquals((Object)Range.integerRange((String)"empty"), (Object)Range.integerRange((String)"(5,5)"));
    }

    @Test
    public void emptyRangeWithEmptyKeyword() {
        Range empty = Range.localDateRange((String)"empty");
        Assert.assertTrue((boolean)empty.isEmpty());
        Assert.assertFalse((boolean)empty.contains((Comparable)LocalDate.MIN));
        Assert.assertFalse((boolean)empty.contains((Comparable)null));
        Assert.assertFalse((boolean)empty.contains((Comparable)LocalDate.now()));
        Assert.assertFalse((boolean)empty.contains((Comparable)LocalDate.MAX));
        Assert.assertNull((Object)empty.upper());
        Assert.assertNull((Object)empty.lower());
    }

    @Test
    public void asStringWithEmptyKeyword() {
        Range empty = Range.integerRange((String)"empty");
        Assert.assertEquals((Object)"empty", (Object)empty.asString());
    }

    @Test
    public void asStringWithEmptyValue() {
        Range empty = Range.integerRange((String)"(5,5)");
        Assert.assertEquals((Object)"(5,5)", (Object)empty.asString());
    }

    @Test
    public void asStringWithInfinity() {
        Range infinity = Range.integerRange((String)"(,)");
        Assert.assertEquals((Object)"(,)", (Object)infinity.asString());
    }

    @Test
    public void emptyRangeWithValues() {
        Range empty = Range.localDateRange((String)"(2019-03-27,2019-03-27)");
        Assert.assertTrue((boolean)empty.isEmpty());
        Assert.assertFalse((boolean)empty.contains((Comparable)LocalDate.MIN));
        Assert.assertFalse((boolean)empty.contains((Comparable)LocalDate.now()));
        Assert.assertFalse((boolean)empty.contains((Comparable)LocalDate.MAX));
        Assert.assertTrue((boolean)Range.integerRange((String)"(5,5)").isEmpty());
    }

    @Test
    public void notEmptyWithValues() {
        Assert.assertFalse((boolean)Range.integerRange((String)"(5,)").isEmpty());
        Assert.assertFalse((boolean)Range.integerRange((String)"(5,5]").isEmpty());
        Assert.assertFalse((boolean)Range.integerRange((String)"(,5)").isEmpty());
        Assert.assertFalse((boolean)Range.integerRange((String)"(,)").isEmpty());
    }
}

