/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.range;

import io.hypersistence.utils.hibernate.type.range.PostgreSQLRangeType;
import io.hypersistence.utils.hibernate.type.range.Range;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLRangeTypeTest
extends AbstractPostgreSQLIntegrationTest {
    private final Range<BigDecimal> numeric = Range.bigDecimalRange((String)"[0.5,0.89]");
    private final Range<Long> int8Range = Range.longRange((String)"[0,18)");
    private final Range<Integer> int4Range = Range.infinite(Integer.class);
    private final Range<Integer> int4RangeEmpty = Range.integerRange((String)"[123,123)");
    private final Range<Integer> int4RangeInfinity = Range.integerRange((String)"[123,infinity)");
    private final Range<LocalDateTime> localDateTimeRange = Range.localDateTimeRange((String)"[2014-04-28 16:00:49,2015-04-28 16:00:49]");
    private final Range<ZonedDateTime> tsTz = Range.zonedDateTimeRange((String)"[\"2007-12-03T10:15:30+01:00\",\"2008-12-03T10:15:30+01:00\"]");
    private final Range<ZonedDateTime> tsTzEmpty = Range.zonedDateTimeRange((String)"empty");
    private final Range<ZonedDateTime> infinityTsTz = Range.zonedDateTimeRange((String)"[\"2007-12-03T10:15:30+01:00\",infinity)");
    private final Range<LocalDate> dateRange = Range.localDateRange((String)"[1992-01-13,1995-01-13)");

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Restriction.class};
    }

    @Test
    public void test() {
        Restriction _restriction = (Restriction)this.doInJPA(entityManager -> {
            entityManager.persist((Object)new Restriction());
            Restriction restriction = new Restriction();
            restriction.setRangeInt(this.int4Range);
            restriction.setRangeIntEmpty(this.int4RangeEmpty);
            restriction.setRangeIntInfinity(this.int4RangeInfinity);
            restriction.setRangeLong(this.int8Range);
            restriction.setRangeBigDecimal(this.numeric);
            restriction.setRangeLocalDateTime(this.localDateTimeRange);
            restriction.setRangeZonedDateTime(this.tsTz);
            restriction.setRangeZonedDateTimeInfinity(this.infinityTsTz);
            restriction.setRangeZonedDateTimeEmpty(this.tsTzEmpty);
            restriction.setRangeLocalDate(this.dateRange);
            entityManager.persist((Object)restriction);
            return restriction;
        });
        this.doInJPA(entityManager -> {
            Restriction restriction = (Restriction)entityManager.find(Restriction.class, (Object)_restriction.getId());
            Assert.assertEquals(this.int4Range, restriction.getRangeInt());
            Assert.assertEquals((Object)Range.emptyRange(Integer.class), restriction.getRangeIntEmpty());
            Assert.assertEquals(this.int4RangeInfinity, restriction.getRangeIntInfinity());
            Assert.assertEquals(this.int8Range, restriction.getRangeLong());
            Assert.assertEquals(this.numeric, restriction.getRangeBigDecimal());
            Assert.assertEquals(this.localDateTimeRange, restriction.getLocalDateTimeRange());
            Assert.assertEquals(this.dateRange, restriction.getRangeLocalDate());
            ZoneId zone = ((ZonedDateTime)restriction.getRangeZonedDateTime().lower()).getZone();
            ZonedDateTime lower = ((ZonedDateTime)this.tsTz.lower()).withZoneSameInstant(zone);
            ZonedDateTime upper = ((ZonedDateTime)this.tsTz.upper()).withZoneSameInstant(zone);
            Assert.assertEquals(restriction.getRangeZonedDateTime(), (Object)Range.closed((Comparable)lower, (Comparable)upper));
            lower = ((ZonedDateTime)this.infinityTsTz.lower()).withZoneSameInstant(zone);
            Assert.assertEquals(restriction.getRangeZonedDateTimeInfinity(), (Object)Range.closedInfinite((Comparable)lower));
        });
    }

    @Test
    public void testNullRange() {
        Restriction _restriction = (Restriction)this.doInJPA(entityManager -> {
            Restriction restriction = new Restriction();
            entityManager.persist((Object)restriction);
            return restriction;
        });
        this.doInJPA(entityManager -> {
            Restriction restriction = (Restriction)entityManager.find(Restriction.class, (Object)_restriction.getId());
            Assert.assertNull(restriction.getRangeInt());
            Assert.assertNull(restriction.getRangeIntEmpty());
            Assert.assertNull(restriction.getRangeIntInfinity());
            Assert.assertNull(restriction.getRangeLong());
            Assert.assertNull(restriction.getRangeBigDecimal());
            Assert.assertNull(restriction.getLocalDateTimeRange());
            Assert.assertNull(restriction.getRangeLocalDate());
            Assert.assertNull(restriction.getRangeZonedDateTime());
            Assert.assertNull(restriction.getRangeZonedDateTimeInfinity());
            Assert.assertNull(restriction.getRangeZonedDateTimeEmpty());
        });
    }

    @Entity(name="AgeRestriction")
    @Table(name="age_restriction")
    public static class Restriction {
        @Id
        @GeneratedValue
        private Long id;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_int", columnDefinition="int4Range")
        private Range<Integer> rangeInt;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_int_empty", columnDefinition="int4Range")
        private Range<Integer> rangeIntEmpty;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_int_infinity", columnDefinition="int4Range")
        private Range<Integer> rangeIntInfinity;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_long", columnDefinition="int8range")
        private Range<Long> rangeLong;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_numeric", columnDefinition="numrange")
        private Range<BigDecimal> rangeBigDecimal;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_ts", columnDefinition="tsrange")
        private Range<LocalDateTime> rangeLocalDateTime;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_ts_tz", columnDefinition="tstzrange")
        private Range<ZonedDateTime> rangeZonedDateTime;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_ts_tz_infinity", columnDefinition="tstzrange")
        private Range<ZonedDateTime> rangeZonedDateTimeInfinity;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_ts_tz_empty", columnDefinition="tstzrange")
        private Range<ZonedDateTime> rangeZonedDateTimeEmpty;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_date", columnDefinition="daterange")
        private Range<LocalDate> rangeLocalDate;

        public Long getId() {
            return this.id;
        }

        public Range<Integer> getRangeInt() {
            return this.rangeInt;
        }

        public void setRangeInt(Range<Integer> rangeInt) {
            this.rangeInt = rangeInt;
        }

        public Range<Integer> getRangeIntEmpty() {
            return this.rangeIntEmpty;
        }

        public void setRangeIntEmpty(Range<Integer> rangeIntEmpty) {
            this.rangeIntEmpty = rangeIntEmpty;
        }

        public Range<Integer> getRangeIntInfinity() {
            return this.rangeIntInfinity;
        }

        public void setRangeIntInfinity(Range<Integer> rangeIntInfinity) {
            this.rangeIntInfinity = rangeIntInfinity;
        }

        public Range<Long> getRangeLong() {
            return this.rangeLong;
        }

        public void setRangeLong(Range<Long> rangeLong) {
            this.rangeLong = rangeLong;
        }

        public Range<BigDecimal> getRangeBigDecimal() {
            return this.rangeBigDecimal;
        }

        public void setRangeBigDecimal(Range<BigDecimal> rangeBigDecimal) {
            this.rangeBigDecimal = rangeBigDecimal;
        }

        public Range<LocalDateTime> getLocalDateTimeRange() {
            return this.rangeLocalDateTime;
        }

        public void setRangeLocalDateTime(Range<LocalDateTime> rangeLocalDateTime) {
            this.rangeLocalDateTime = rangeLocalDateTime;
        }

        public Range<ZonedDateTime> getRangeZonedDateTime() {
            return this.rangeZonedDateTime;
        }

        public void setRangeZonedDateTime(Range<ZonedDateTime> rangeZonedDateTime) {
            this.rangeZonedDateTime = rangeZonedDateTime;
        }

        public Range<ZonedDateTime> getRangeZonedDateTimeInfinity() {
            return this.rangeZonedDateTimeInfinity;
        }

        public Range<ZonedDateTime> getRangeZonedDateTimeEmpty() {
            return this.rangeZonedDateTimeEmpty;
        }

        public void setRangeZonedDateTimeEmpty(Range<ZonedDateTime> rangeZonedDateTimeEmpty) {
            this.rangeZonedDateTimeEmpty = rangeZonedDateTimeEmpty;
        }

        public void setRangeZonedDateTimeInfinity(Range<ZonedDateTime> rangeZonedDateTimeInfinity) {
            this.rangeZonedDateTimeInfinity = rangeZonedDateTimeInfinity;
        }

        public Range<LocalDate> getRangeLocalDate() {
            return this.rangeLocalDate;
        }

        public void setRangeLocalDate(Range<LocalDate> rangeLocalDate) {
            this.rangeLocalDate = rangeLocalDate;
        }
    }
}

