/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.range;

import io.hypersistence.utils.hibernate.type.range.PostgreSQLRangeType;
import io.hypersistence.utils.hibernate.type.range.Range;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLRangeTypeDSTTest
extends AbstractPostgreSQLIntegrationTest {
    private final Range<ZonedDateTime> tsTz = Range.zonedDateTimeRange((String)"[\"2018-05-03T10:15:30+12:00\",\"2018-12-03T10:15:30+12:00\"]");

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Restriction.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Restriction restriction = new Restriction();
            restriction.setId(1L);
            restriction.setRangeZonedDateTime(this.tsTz);
            entityManager.persist((Object)restriction);
            return restriction;
        });
        this.doInJPA(entityManager -> {
            Restriction ar = (Restriction)entityManager.find(Restriction.class, (Object)1L);
            ZoneId zone = ((ZonedDateTime)ar.getRangeZonedDateTime().lower()).getZone();
            ZonedDateTime lower = ((ZonedDateTime)this.tsTz.lower()).withZoneSameInstant(zone);
            Assert.assertEquals((Object)lower, (Object)ar.getRangeZonedDateTime().lower());
            Assert.assertEquals((Object)LocalDateTime.parse("2018-12-03T10:15:30").atZone(ZoneId.systemDefault()).getOffset(), (Object)((ZonedDateTime)ar.getRangeZonedDateTime().upper()).getOffset());
        });
    }

    @Entity(name="AgeRestriction")
    @Table(name="age_restriction")
    public static class Restriction {
        @Id
        private Long id;
        @Type(value=PostgreSQLRangeType.class)
        @Column(name="r_tstzrange", columnDefinition="tstzrange")
        private Range<ZonedDateTime> rangeZonedDateTime;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Range<ZonedDateTime> getRangeZonedDateTime() {
            return this.rangeZonedDateTime;
        }

        public void setRangeZonedDateTime(Range<ZonedDateTime> rangeZonedDateTime) {
            this.rangeZonedDateTime = rangeZonedDateTime;
        }
    }
}

