/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.money;

import io.hypersistence.utils.hibernate.type.money.CurrencyUnitType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLCurrencyUnitTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Order.class};
    }

    @Test
    public void testPersistAndReadCurrency() {
        Order _order = (Order)this.doInJPA(entityManager -> {
            Order order = new Order();
            order.setCurrency(Monetary.getCurrency((String)"EUR", (String[])new String[0]));
            entityManager.persist((Object)order);
            return order;
        });
        this.doInJPA(entityManager -> {
            Order order = (Order)entityManager.find(Order.class, (Object)_order.getId());
            Assert.assertEquals((Object)order.getCurrency(), (Object)Monetary.getCurrency((String)"EUR", (String[])new String[0]));
        });
    }

    @Test
    public void testSearchByCurrency() {
        this.doInJPA(entityManager -> {
            Order order1 = new Order();
            order1.setCurrency(Monetary.getCurrency((String)"EUR", (String[])new String[0]));
            entityManager.persist((Object)order1);
            Order order2 = new Order();
            order2.setCurrency(Monetary.getCurrency((String)"PLN", (String[])new String[0]));
            entityManager.persist((Object)order2);
        });
        this.doInJPA(entityManager -> {
            CurrencyUnit currency = Monetary.getCurrency((String)"PLN", (String[])new String[0]);
            Order order = (Order)entityManager.createQuery("select o from Order o where o.currency = :currency", Order.class).setParameter("currency", (Object)currency).getSingleResult();
            Assert.assertEquals((Object)2L, (Object)order.getId());
        });
    }

    @Test
    public void testReturnNullCurrency() {
        Long _id = (Long)this.doInJPA(entityManager -> {
            Order order = new Order();
            entityManager.persist((Object)order);
            return order.getId();
        });
        this.doInJPA(entityManager -> {
            Order order = (Order)entityManager.createQuery("select o from Order o where o.id = :id", Order.class).setParameter("id", (Object)_id).getSingleResult();
            Assert.assertNull((Object)order.getCurrency());
        });
        this.doInJPA(entityManager -> {
            CurrencyUnit currency = (CurrencyUnit)entityManager.createQuery("select o.currency from Order o where o.id = :id", CurrencyUnit.class).setParameter("id", (Object)_id).getSingleResult();
            Assert.assertNull((Object)currency);
        });
    }

    @Entity(name="Order")
    @Table(name="orders")
    public static class Order {
        @Id
        @GeneratedValue
        private Long id;
        @Type(value=CurrencyUnitType.class)
        @Column(name="currency", columnDefinition="char(3)")
        private CurrencyUnit currency;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public CurrencyUnit getCurrency() {
            return this.currency;
        }

        public void setCurrency(CurrencyUnit currency) {
            this.currency = currency;
        }
    }
}

