/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.money;

import io.hypersistence.utils.hibernate.type.money.MonetaryAmountType;
import io.hypersistence.utils.hibernate.util.AbstractMySQLIntegrationTest;
import jakarta.persistence.AttributeOverride;
import jakarta.persistence.AttributeOverrides;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import javax.money.MonetaryAmount;
import org.hibernate.annotations.CompositeType;
import org.hibernate.envers.Audited;
import org.javamoney.moneta.Money;
import org.junit.Assert;
import org.junit.Test;

public class MySQLMonetaryAmountTypeTest
extends AbstractMySQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Salary.class};
    }

    @Test
    public void testReadAndWrite() {
        Salary _salary = (Salary)this.doInJPA(entityManager -> {
            Salary salary = new Salary();
            salary.setSalary((MonetaryAmount)Money.of((BigDecimal)new BigDecimal("10.23"), (String)"USD"));
            entityManager.persist((Object)salary);
            return salary;
        });
        this.doInJPA(entityManager -> {
            Salary salary = (Salary)entityManager.find(Salary.class, (Object)_salary.getId());
            Assert.assertEquals((Object)salary.getSalary(), (Object)Money.of((BigDecimal)new BigDecimal("10.23"), (String)"USD"));
        });
        Salary salary = (Salary)this.doInJPA(entityManager -> (Salary)entityManager.find(Salary.class, (Object)_salary.getId()));
        salary.setSalary((MonetaryAmount)Money.of((BigDecimal)new BigDecimal("10.49"), (String)"USD"));
        this.doInJPA(entityManager -> entityManager.merge((Object)salary));
    }

    @Test
    public void testSearchByMoney() {
        this.doInJPA(entityManager -> {
            Salary salary1 = new Salary();
            salary1.setSalary((MonetaryAmount)Money.of((BigDecimal)new BigDecimal("10.23"), (String)"USD"));
            entityManager.persist((Object)salary1);
            Salary salary2 = new Salary();
            salary2.setSalary((MonetaryAmount)Money.of((BigDecimal)new BigDecimal("20.23"), (String)"EUR"));
            entityManager.persist((Object)salary2);
        });
        this.doInJPA(entityManager -> {
            Money money = Money.of((BigDecimal)new BigDecimal("10.23"), (String)"USD");
            Salary salary = (Salary)entityManager.createQuery("select s from Salary s where s.salary = :salary", Salary.class).setParameter("salary", (Object)money).getSingleResult();
            Assert.assertEquals((Object)1L, (Object)salary.getId());
        });
    }

    @Test
    public void testReturnNullMoney() {
        Long _id = (Long)this.doInJPA(entityManager -> {
            Salary salary = new Salary();
            entityManager.persist((Object)salary);
            return salary.getId();
        });
        this.doInJPA(entityManager -> {
            Salary salary = (Salary)entityManager.createQuery("select s from Salary s where s.id = :id", Salary.class).setParameter("id", (Object)_id).getSingleResult();
            Assert.assertNull((Object)salary.getSalary());
        });
        this.doInJPA(entityManager -> {
            MonetaryAmount money = (MonetaryAmount)entityManager.createQuery("select s.salary from Salary s where s.id = :id", MonetaryAmount.class).setParameter("id", (Object)_id).getSingleResult();
            Assert.assertNull((Object)money);
        });
    }

    @Audited
    @Entity(name="Salary")
    @Table(name="salary")
    public static class Salary {
        @Id
        @GeneratedValue
        private Long id;
        private String other;
        @AttributeOverrides(value={@AttributeOverride(name="amount", column=@Column(name="salary_amount")), @AttributeOverride(name="currency", column=@Column(name="salary_currency"))})
        @CompositeType(value=MonetaryAmountType.class)
        private MonetaryAmount salary;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public MonetaryAmount getSalary() {
            return this.salary;
        }

        public void setSalary(MonetaryAmount salary) {
            this.salary = salary;
        }

        public String getOther() {
            return this.other;
        }

        public void setOther(String other) {
            this.other = other;
        }
    }
}

