/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.polymorphic;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonPolymorphicListJacksonTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Book().setIsbn("978-9730228236").addCoupon(new AmountDiscountCoupon("PPP").setAmount(new BigDecimal("4.99"))).addCoupon(new PercentageDiscountCoupon("Black Friday").setPercentage(BigDecimal.valueOf(0.02)))));
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Map topics = book.getCoupons().stream().collect(Collectors.toMap(DiscountCoupon::getName, Function.identity()));
            Assert.assertEquals((long)2L, (long)topics.size());
            AmountDiscountCoupon amountDiscountCoupon = (AmountDiscountCoupon)topics.get("PPP");
            Assert.assertEquals((Object)new BigDecimal("4.99"), (Object)amountDiscountCoupon.getAmount());
            PercentageDiscountCoupon percentageDiscountCoupon = (PercentageDiscountCoupon)topics.get("Black Friday");
            Assert.assertEquals((Object)BigDecimal.valueOf(0.02), (Object)percentageDiscountCoupon.getPercentage());
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        @Column(length=15)
        private String isbn;
        @Type(value=JsonType.class)
        @Column(columnDefinition="jsonb")
        private List<DiscountCoupon> coupons = new ArrayList<DiscountCoupon>();

        public String getIsbn() {
            return this.isbn;
        }

        public Book setIsbn(String isbn) {
            this.isbn = isbn;
            return this;
        }

        public List<DiscountCoupon> getCoupons() {
            return this.coupons;
        }

        public Book setCoupons(List<DiscountCoupon> coupons) {
            this.coupons = coupons;
            return this;
        }

        public Book addCoupon(DiscountCoupon topic) {
            this.coupons.add(topic);
            return this;
        }
    }

    public static class AmountDiscountCoupon
    extends DiscountCoupon {
        public static final String DISCRIMINATOR = "discount.coupon.amount";
        private BigDecimal amount;

        public AmountDiscountCoupon() {
        }

        public AmountDiscountCoupon(String name) {
            super(name);
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public AmountDiscountCoupon setAmount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        @Override
        public String getType() {
            return DISCRIMINATOR;
        }
    }

    public static class PercentageDiscountCoupon
    extends DiscountCoupon {
        public static final String DISCRIMINATOR = "discount.coupon.percentage";
        private BigDecimal percentage;

        public PercentageDiscountCoupon() {
        }

        public PercentageDiscountCoupon(String name) {
            super(name);
        }

        public BigDecimal getPercentage() {
            return this.percentage;
        }

        public PercentageDiscountCoupon setPercentage(BigDecimal amount) {
            this.percentage = amount;
            return this;
        }

        @Override
        public String getType() {
            return DISCRIMINATOR;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
    @JsonSubTypes(value={@JsonSubTypes.Type(name="discount.coupon.amount", value=AmountDiscountCoupon.class), @JsonSubTypes.Type(name="discount.coupon.percentage", value=PercentageDiscountCoupon.class)})
    public static abstract class DiscountCoupon
    implements Serializable {
        private String name;

        public DiscountCoupon() {
        }

        public DiscountCoupon(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
        public abstract String getType();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DiscountCoupon)) {
                return false;
            }
            DiscountCoupon that = (DiscountCoupon)o;
            return Objects.equals(this.getName(), that.getName());
        }

        public int hashCode() {
            return Objects.hash(this.getName());
        }
    }
}

