/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.internal;

import io.hypersistence.utils.hibernate.type.json.internal.JsonJavaTypeDescriptor;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.HibernateException;
import org.junit.Assert;
import org.junit.Test;

public class JsonTypeDescriptorTest {
    @Test
    public void testSetsAreEqual() {
        JsonJavaTypeDescriptor descriptor = new JsonJavaTypeDescriptor();
        Form theFirst = this.createForm(1, 2, 3);
        Form theSecond = this.createForm(3, 2, 1);
        Assert.assertTrue((boolean)descriptor.areEqual((Object)theFirst, (Object)theSecond));
    }

    @Test
    public void testNullPropertyType() {
        JsonJavaTypeDescriptor descriptor = new JsonJavaTypeDescriptor();
        try {
            descriptor.wrap((Object)"a", null);
            Assert.fail((String)"Should fail because the propertyType is null!");
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
    }

    private Form createForm(Integer ... numbers) {
        Form form = new Form();
        LinkedHashSet<FormField> formFields = new LinkedHashSet<FormField>();
        Arrays.asList(numbers).forEach(o -> {
            FormField formField = new FormField();
            formField.setNumber((Integer)o);
            formFields.add(formField);
        });
        form.setFormFields(formFields);
        return form;
    }

    public static class Form
    extends BaseEntity {
        private Set<FormField> formFields;

        public Set<FormField> getFormFields() {
            return this.formFields;
        }

        public void setFormFields(Set<FormField> formFields) {
            this.formFields = formFields;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Form)) {
                return false;
            }
            Form form = (Form)o;
            return Objects.equals(this.formFields, form.formFields);
        }

        public int hashCode() {
            return Objects.hash(this.formFields);
        }
    }

    public static class FormField {
        private Integer number;

        public Integer getNumber() {
            return this.number;
        }

        public void setNumber(Integer number) {
            this.number = number;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FormField formField = (FormField)o;
            return Objects.equals(this.number, formField.number);
        }

        public int hashCode() {
            return Objects.hash(this.number);
        }
    }
}

