/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.internal;

import io.hypersistence.utils.hibernate.type.json.internal.JacksonUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;

public class JacksonUtilTest {
    @Test
    public void cloneDeserializeStepErrorTest() {
        MyEntity entity = new MyEntity();
        entity.setValue("some value");
        entity.setPojos(Arrays.asList(this.createMyPojo("first value", MyType.A, "1.1", this.createOtherPojo("USD")), this.createMyPojo("second value", MyType.B, "1.2", this.createOtherPojo("BRL"))));
        MyEntity clone = (MyEntity)JacksonUtil.clone((Object)entity);
        Assert.assertEquals((Object)clone, (Object)entity);
        List clonePojos = (List)JacksonUtil.clone(entity.getPojos());
        Assert.assertEquals((Object)clonePojos, entity.getPojos());
    }

    private MyPojo createMyPojo(String value, MyType myType, String number, OtherPojo otherPojo) {
        MyPojo myPojo = new MyPojo();
        myPojo.setValue(value);
        myPojo.setType(myType);
        myPojo.setNumber(new BigDecimal(number));
        myPojo.setOtherPojo(otherPojo);
        return myPojo;
    }

    private OtherPojo createOtherPojo(String currency) {
        OtherPojo otherPojo = new OtherPojo();
        otherPojo.setCurrency(Currency.getInstance(currency));
        return otherPojo;
    }

    public static class MyEntity {
        private String value;
        private List<MyPojo> pojos;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public List<MyPojo> getPojos() {
            return this.pojos;
        }

        public void setPojos(List<MyPojo> pojos) {
            this.pojos = pojos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyEntity myEntity = (MyEntity)o;
            return Objects.equals(this.value, myEntity.value) && Objects.equals(this.pojos, myEntity.pojos);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.pojos);
        }
    }

    public static class MyPojo
    implements Serializable {
        private String value;
        private MyType type;
        private BigDecimal number;
        private OtherPojo otherPojo;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public MyType getType() {
            return this.type;
        }

        public void setType(MyType type) {
            this.type = type;
        }

        public BigDecimal getNumber() {
            return this.number;
        }

        public void setNumber(BigDecimal number) {
            this.number = number;
        }

        public OtherPojo getOtherPojo() {
            return this.otherPojo;
        }

        public void setOtherPojo(OtherPojo otherPojo) {
            this.otherPojo = otherPojo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            return Objects.equals(this.value, myPojo.value) && this.type == myPojo.type && Objects.equals(this.number, myPojo.number) && Objects.equals(this.otherPojo, myPojo.otherPojo);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.value, this.type, this.number, this.otherPojo});
        }
    }

    public static enum MyType {
        A,
        B,
        C;

    }

    public static class OtherPojo
    implements Serializable {
        private Currency currency;

        public Currency getCurrency() {
            return this.currency;
        }

        public void setCurrency(Currency currency) {
            this.currency = currency;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OtherPojo otherPojo = (OtherPojo)o;
            return Objects.equals(this.currency, otherPojo.currency);
        }

        public int hashCode() {
            return Objects.hash(this.currency);
        }
    }
}

