/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.generic;

import io.hypersistence.utils.hibernate.type.json.JsonType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.type.model.Location;
import io.hypersistence.utils.hibernate.type.model.Ticket;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.hibernate.annotations.Type;
import org.hibernate.query.BindableType;
import org.hibernate.query.NativeQuery;
import org.junit.Assert;
import org.junit.Test;

public class GenericPostgreSQLJsonTypeTest
extends AbstractPostgreSQLIntegrationTest {
    private Event _event;
    private Participant _participant;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class, Participant.class};
    }

    @Override
    protected String[] packages() {
        return new String[]{Location.class.getPackage().getName()};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Location location = new Location();
            location.setCountry("Romania");
            location.setCity("Cluj-Napoca");
            Event event = new Event();
            event.setId(1L);
            event.setLocation(location);
            entityManager.persist((Object)event);
            Ticket ticket = new Ticket();
            ticket.setPrice(12.34);
            ticket.setRegistrationCode("ABC123");
            Participant participant = new Participant();
            participant.setId(1L);
            participant.setTicket(ticket);
            participant.setEvent(event);
            entityManager.persist((Object)participant);
            this._event = event;
            this._participant = participant;
        });
    }

    @Test
    public void testLoad() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            Assert.assertEquals((Object)"Romania", (Object)event.getLocation().getCountry());
            Assert.assertEquals((Object)"Cluj-Napoca", (Object)event.getLocation().getCity());
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertSelectCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    @Test
    public void testBulkUpdate() {
        this.doInJPA(entityManager -> {
            Location location = new Location();
            location.setCountry("Romania");
            location.setCity("Sibiu");
            ((NativeQuery)entityManager.createNativeQuery("update Event set location = :location where id = :id").setParameter("id", (Object)this._event.getId()).unwrap(NativeQuery.class)).setParameter("location", (Object)location, (BindableType)new JsonType(Location.class)).executeUpdate();
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            Assert.assertEquals((Object)"Sibiu", (Object)event.getLocation().getCity());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=JsonType.class)
        @Column(columnDefinition="jsonb")
        private Location location;

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }
    }

    @Entity(name="Participant")
    @Table(name="participant")
    public static class Participant
    extends BaseEntity {
        @Type(value=JsonType.class)
        @Column(columnDefinition="jsonb")
        private Ticket ticket;
        @ManyToOne
        private Event event;

        public Ticket getTicket() {
            return this.ticket;
        }

        public void setTicket(Ticket ticket) {
            this.ticket = ticket;
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }
    }
}

