/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.generic;

import com.fasterxml.jackson.databind.JsonNode;
import io.hypersistence.utils.hibernate.type.json.JsonStringType;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.hibernate.query.NativeQuery;
import org.hibernate.usertype.UserType;
import org.junit.Assert;
import org.junit.Test;

public class GenericPostgreSQLJsonStringTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Book().setIsbn("978-9730228236").setProperties("{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99}")));
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.type_contributors", () -> Collections.singletonList((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)new JsonStringType(JsonNode.class))));
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            book.setProperties("{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99,   \"url\": \"https://www.amazon.com/High-Performance-Java-Persistence-Vlad-Mihalcea/dp/973022823X/\"}");
        });
        this.doInJPA(entityManager -> {
            JsonType jsonType = new JsonType(JsonNode.class);
            JsonNode properties = (JsonNode)((NativeQuery)entityManager.createNativeQuery("SELECT   properties AS properties FROM book WHERE   isbn = :isbn").setParameter("isbn", (Object)"978-9730228236").unwrap(NativeQuery.class)).addScalar("properties", JsonNode.class).getSingleResult();
            Assert.assertEquals((Object)"High-Performance Java Persistence", (Object)properties.get("title").asText());
        });
    }

    @Test
    public void testNullValue() {
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            book.setProperties(null);
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertNull((Object)book.getProperties());
        });
    }

    @Test
    public void testLoad() {
        this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            Book book = (Book)session.bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertTrue((boolean)book.getProperties().contains("\"price\": 44.99"));
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        @Type(value=JsonType.class)
        @Column(columnDefinition="jsonb")
        private String properties;

        public String getIsbn() {
            return this.isbn;
        }

        public Book setIsbn(String isbn) {
            this.isbn = isbn;
            return this;
        }

        public String getProperties() {
            return this.properties;
        }

        public Book setProperties(String properties) {
            this.properties = properties;
            return this;
        }
    }
}

