/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.generic;

import com.fasterxml.jackson.databind.JsonNode;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import io.hypersistence.utils.hibernate.type.json.internal.JacksonUtil;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class GenericPostgreSQLJsonNodeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setIsbn("978-9730228236");
            book.setProperties(JacksonUtil.toJsonNode((String)"{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99}"));
            entityManager.persist((Object)book);
        });
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            Book book = (Book)session.bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            SQLStatementCountValidator.reset();
            book.setProperties(JacksonUtil.toJsonNode((String)"{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99,   \"url\": \"https://www.amazon.com/High-Performance-Java-Persistence-Vlad-Mihalcea/dp/973022823X/\"}"));
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)1);
    }

    @Test
    public void testLoad() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            Book book = (Book)session.bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertEquals((Object)this.expectedPrice(), (Object)book.getProperties().get("price").asText());
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertSelectCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    protected String initialPrice() {
        return "44.99";
    }

    protected String expectedPrice() {
        return "44.99";
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        @Type(value=JsonType.class)
        @Column(columnDefinition="jsonb")
        private JsonNode properties;

        public String getIsbn() {
            return this.isbn;
        }

        public void setIsbn(String isbn) {
            this.isbn = isbn;
        }

        public JsonNode getProperties() {
            return this.properties;
        }

        public void setProperties(JsonNode properties) {
            this.properties = properties;
        }
    }
}

