/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.configuration;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.type.json.configuration.CustomObjectMapperSupplier;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Properties;
import org.hibernate.usertype.UserType;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonBinaryTypeProgrammaticConfigurationTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    protected void additionalProperties(Properties properties) {
        CustomObjectMapperSupplier customObjectMapperSupplier = new CustomObjectMapperSupplier();
        JsonBinaryType jsonBinaryType = new JsonBinaryType(customObjectMapperSupplier.get(), Location.class);
        properties.put("hibernate.type_contributors", () -> Collections.singletonList((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)jsonBinaryType)));
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Location location = new Location();
            location.setCountry("Romania");
            location.setCity("Cluj-Napoca");
            location.setReference(BigDecimal.valueOf(2.25262562526626));
            Event event = new Event();
            event.setId(1L);
            event.setLocation(location);
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertEquals((Object)"2.25", (Object)event.getLocation().getReference().toString());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event {
        @Id
        private Long id;
        @Column(columnDefinition="jsonb")
        private Location location;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }
    }

    public static class Location
    implements Serializable {
        private String country;
        private String city;
        private BigDecimal reference;

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public BigDecimal getReference() {
            return this.reference;
        }

        public void setReference(BigDecimal reference) {
            this.reference = reference;
        }
    }
}

