/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json.configuration;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonBinaryTypeConfigurationJvmForkTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    public void init() {
        System.setProperty("hypersistence-utils.properties.path", "PostgreSQLJsonBinaryTypeConfigurationTest.properties");
        super.init();
    }

    @Override
    public void destroy() {
        super.destroy();
        System.getProperties().remove("hypersistence-utils.properties.path");
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Location location = new Location();
            location.setCountry("Romania");
            location.setCity("Cluj-Napoca");
            location.setReference(BigDecimal.valueOf(2.25262562526626));
            Event event = new Event();
            event.setId(1L);
            event.setLocation(location);
            entityManager.persist((Object)event);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)1L);
            Assert.assertEquals((Object)"2.25", (Object)event.getLocation().getReference().toString());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private Location location;

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }
    }

    public static class Location
    implements Serializable {
        private String country;
        private String city;
        private BigDecimal reference;

        public String getCountry() {
            return this.country;
        }

        public void setCountry(String country) {
            this.country = country;
        }

        public String getCity() {
            return this.city;
        }

        public void setCity(String city) {
            this.city = city;
        }

        public BigDecimal getReference() {
            return this.reference;
        }

        public void setReference(BigDecimal reference) {
            this.reference = reference;
        }
    }
}

