/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import com.fasterxml.jackson.databind.JsonNode;
import io.hypersistence.utils.hibernate.type.json.JsonStringType;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import io.hypersistence.utils.hibernate.util.AbstractSQLServerIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.hibernate.query.NativeQuery;
import org.hibernate.usertype.UserType;
import org.junit.Assert;
import org.junit.Test;

public class SQLServerJsonStringPropertyTest
extends AbstractSQLServerIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Book().setIsbn("978-9730228236").setProperties("{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99}")));
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.type_contributors", () -> Collections.singletonList((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)new JsonStringType(JsonNode.class))));
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            SQLStatementCountValidator.reset();
            book.setProperties("{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99,   \"url\": \"https://www.amazon.com/High-Performance-Java-Persistence-Vlad-Mihalcea/dp/973022823X/\"}");
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)1);
        this.doInJPA(entityManager -> {
            JsonNode properties = (JsonNode)((NativeQuery)entityManager.createNativeQuery("SELECT   properties AS properties FROM book WHERE   isbn = :isbn").setParameter("isbn", (Object)"978-9730228236").unwrap(NativeQuery.class)).addScalar("properties", JsonNode.class).getSingleResult();
            Assert.assertEquals((Object)"High-Performance Java Persistence", (Object)properties.get("title").asText());
        });
    }

    @Test
    public void testNullValue() {
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            SQLStatementCountValidator.reset();
            book.setProperties(null);
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)1);
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertNull((Object)book.getProperties());
        });
    }

    @Test
    public void testLoad() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            Book book = (Book)session.bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertTrue((boolean)book.getProperties().contains("\"price\": 44.99"));
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertSelectCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        @Type(value=JsonType.class)
        @Column(columnDefinition="NVARCHAR(1000)")
        @Check(constraints="ISJSON(properties) = 1")
        private String properties;

        public String getIsbn() {
            return this.isbn;
        }

        public Book setIsbn(String isbn) {
            this.isbn = isbn;
            return this;
        }

        public String getProperties() {
            return this.properties;
        }

        public Book setProperties(String properties) {
            this.properties = properties;
            return this;
        }
    }
}

