/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.type.model.Location;
import io.hypersistence.utils.hibernate.type.model.Ticket;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.List;
import net.ttddyy.dsproxy.QueryCount;
import net.ttddyy.dsproxy.QueryCountHolder;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonStringTypeTest
extends AbstractPostgreSQLIntegrationTest {
    private Event _event;
    private Participant _participant;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class, Participant.class};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Location location = new Location();
            location.setCountry("Romania");
            location.setCity("Cluj-Napoca");
            Event event = new Event();
            event.setId(1L);
            event.setLocation(location);
            entityManager.persist((Object)event);
            Ticket ticket = new Ticket();
            ticket.setPrice(12.34);
            ticket.setRegistrationCode("ABC123");
            Participant participant = new Participant();
            participant.setId(1L);
            participant.setTicket(ticket);
            participant.setEvent(event);
            entityManager.persist((Object)participant);
            this._event = event;
            this._participant = participant;
        });
    }

    @Test
    public void testLoad() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            Assert.assertEquals((Object)"Cluj-Napoca", (Object)event.getLocation().getCity());
            QueryCount queryCount = QueryCountHolder.getGrandTotal();
            Assert.assertEquals((long)1L, (long)queryCount.getTotal());
            Assert.assertEquals((long)1L, (long)queryCount.getSelect());
            Assert.assertEquals((long)0L, (long)queryCount.getUpdate());
            Participant participant = (Participant)entityManager.find(Participant.class, (Object)this._participant.getId());
            Assert.assertEquals((Object)"ABC123", (Object)participant.getTicket().getRegistrationCode());
            List participants = entityManager.createNativeQuery("select p.ticket ->>'registrationCode' from participant p where p.ticket ->> 'price' > :price").setParameter("price", (Object)"10").getResultList();
            event.getLocation().setCity("Constan\u021ba");
            entityManager.flush();
            Assert.assertEquals((long)1L, (long)participants.size());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="json")
        private Location location;

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }
    }

    @Entity(name="Participant")
    @Table(name="participant")
    public static class Participant
    extends BaseEntity {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="json")
        private Ticket ticket;
        @ManyToOne
        private Event event;

        public Ticket getTicket() {
            return this.ticket;
        }

        public void setTicket(Ticket ticket) {
            this.ticket = ticket;
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }
    }
}

