/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonListPojoTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Book().setIsbn("978-9730228236").addProperty("title", "High-Performance Java Persistence").addProperty("author", "Vlad Mihalcea").addProperty("publisher", "Amazon").addProperty("price", "$44.95")));
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            List<Property> bookProperties = book.getProperties();
            Assert.assertEquals((long)4L, (long)bookProperties.size());
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        @Column(length=15)
        private String isbn;
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private List<Property> properties = new ArrayList<Property>();

        public String getIsbn() {
            return this.isbn;
        }

        public Book setIsbn(String isbn) {
            this.isbn = isbn;
            return this;
        }

        public List<Property> getProperties() {
            return this.properties;
        }

        public Book setProperties(List<Property> properties) {
            this.properties = properties;
            return this;
        }

        public Book addProperty(String key, String value) {
            this.properties.add(new Property(key, value));
            return this;
        }
    }

    public static class Property {
        private String key;
        private String value;

        public Property() {
        }

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

