/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonListEnumTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Book().setIsbn("978-9730228236").addProperty(PropertyType.BEST_SELLER).addProperty(PropertyType.FREE_CHAPTER)));
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            List<PropertyType> bookProperties = book.getProperties();
            Assert.assertEquals((long)2L, (long)bookProperties.size());
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        @Column(length=15)
        private String isbn;
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private List<PropertyType> propertyTypes = new ArrayList<PropertyType>();

        public String getIsbn() {
            return this.isbn;
        }

        public Book setIsbn(String isbn) {
            this.isbn = isbn;
            return this;
        }

        public List<PropertyType> getProperties() {
            return this.propertyTypes;
        }

        public Book setProperties(List<PropertyType> properties) {
            this.propertyTypes = properties;
            return this;
        }

        public Book addProperty(PropertyType propertyType) {
            this.propertyTypes.add(propertyType);
            return this;
        }
    }

    public static enum PropertyType {
        BEST_SELLER,
        FREE_CHAPTER;

    }
}

