/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.type.json.internal.JacksonUtil;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.type.model.Location;
import io.hypersistence.utils.hibernate.type.model.Ticket;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.List;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonBinaryTypeTest
extends AbstractPostgreSQLIntegrationTest {
    private Event _event;
    private Participant _participant;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class, Participant.class};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Location location = new Location();
            location.setCountry("Romania");
            location.setCity("Cluj-Napoca");
            Event event = new Event();
            event.setId(1L);
            event.setLocation(location);
            entityManager.persist((Object)event);
            Ticket ticket = new Ticket();
            ticket.setPrice(12.34);
            ticket.setRegistrationCode("ABC123");
            Participant participant = new Participant();
            participant.setId(1L);
            participant.setTicket(ticket);
            participant.setEvent(event);
            participant.setMetaData(JacksonUtil.toString((Object)location));
            entityManager.persist((Object)participant);
            this._event = event;
            this._participant = participant;
        });
    }

    @Test
    public void testLoad() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            Assert.assertEquals((Object)"Romania", (Object)event.getLocation().getCountry());
            Assert.assertEquals((Object)"Cluj-Napoca", (Object)event.getLocation().getCity());
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertSelectCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            Assert.assertEquals((Object)"Cluj-Napoca", (Object)event.getLocation().getCity());
            Participant participant = (Participant)entityManager.find(Participant.class, (Object)this._participant.getId());
            Assert.assertEquals((Object)"ABC123", (Object)participant.getTicket().getRegistrationCode());
            List participants = entityManager.createNativeQuery("select jsonb_pretty(p.ticket) from participant p where p.ticket ->> 'price' > :price").setParameter("price", (Object)"10").getResultList();
            List countries = entityManager.createNativeQuery("select p.metadata ->> 'country' from participant p where p.id >= :id").setParameter("id", (Object)0).getResultList();
            event.getLocation().setCity("Constan\u021ba");
            Assert.assertEquals((Object)0, (Object)event.getVersion());
            entityManager.flush();
            Assert.assertEquals((Object)1, (Object)event.getVersion());
            Assert.assertEquals((long)1L, (long)participants.size());
            Assert.assertEquals((long)1L, (long)countries.size());
            Assert.assertNotNull(countries.get(0));
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            event.getLocation().setCity(null);
            Assert.assertEquals((Object)1, (Object)event.getVersion());
            entityManager.flush();
            Assert.assertEquals((Object)2, (Object)event.getVersion());
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            event.setLocation(null);
            Assert.assertEquals((Object)2, (Object)event.getVersion());
            entityManager.flush();
            Assert.assertEquals((Object)3, (Object)event.getVersion());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private Location location;

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }
    }

    @Entity(name="Participant")
    @Table(name="participant")
    public static class Participant
    extends BaseEntity {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private Ticket ticket;
        @ManyToOne
        private Event event;
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private String metaData;

        public Ticket getTicket() {
            return this.ticket;
        }

        public void setTicket(Ticket ticket) {
            this.ticket = ticket;
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }

        public String getMetaData() {
            return this.metaData;
        }

        public void setMetaData(String metaData) {
            this.metaData = metaData;
        }
    }
}

