/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonBinaryTypeSetTest
extends AbstractPostgreSQLIntegrationTest {
    private User _user;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{User.class};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            User user = new User();
            user.setId(1L);
            user.setPhones(new HashSet<String>(Arrays.asList("7654321", "1234567")));
            user.setRoles(EnumSet.of(Role.ADMIN, Role.USER));
            user.setChildren(new HashSet<Child>(Arrays.asList(new Child("Jane", 2, new HashSet<String>(Arrays.asList("toy1", "toy2"))), new Child("John", 1, new HashSet<String>(Arrays.asList("toy3", "toy4"))))));
            entityManager.persist((Object)user);
            this._user = user;
        });
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            User user = (User)entityManager.find(User.class, (Object)this._user.getId());
            SQLStatementCountValidator.reset();
            user.setPhones(new HashSet<String>(Arrays.asList("1592637", "9518473")));
            user.setRoles(EnumSet.of(Role.USER, Role.DEV));
            user.setChildren(new HashSet<Child>(Arrays.asList(new Child("Jinny", 1, new HashSet<String>(Arrays.asList("toy5", "toy6"))), new Child("Jenny", 2, new HashSet<String>(Arrays.asList("toy7", "toy8"))))));
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)1);
        this.doInJPA(entityManager -> {
            User user = (User)entityManager.find(User.class, (Object)this._user.getId());
            Assert.assertEquals(new HashSet<String>(Arrays.asList("9518473", "1592637")), user.getPhones());
            Assert.assertEquals(EnumSet.of(Role.DEV, Role.USER), user.getRoles());
            Assert.assertEquals(new HashSet<Child>(Arrays.asList(new Child("Jenny", 2, new HashSet<String>(Arrays.asList("toy8", "toy7"))), new Child("Jinny", 1, new HashSet<String>(Arrays.asList("toy6", "toy5"))))), user.getChildren());
            Assert.assertEquals((Object)1, (Object)user.getVersion());
        });
    }

    @Test
    public void testLoad() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            User user = (User)entityManager.find(User.class, (Object)this._user.getId());
            Assert.assertEquals(new HashSet<String>(Arrays.asList("1234567", "7654321")), user.getPhones());
            Assert.assertEquals(EnumSet.of(Role.USER, Role.ADMIN), user.getRoles());
            Assert.assertEquals(new HashSet<Child>(Arrays.asList(new Child("John", 1, new HashSet<String>(Arrays.asList("toy4", "toy3"))), new Child("Jane", 2, new HashSet<String>(Arrays.asList("toy2", "toy1"))))), user.getChildren());
            Assert.assertEquals((Object)0, (Object)user.getVersion());
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertSelectCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    @Entity
    @Table(name="users")
    @DynamicUpdate
    public static class User
    extends BaseEntity {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private Set<String> phones;
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private EnumSet<Role> roles;
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private Set<Child> children;

        public Set<String> getPhones() {
            return this.phones;
        }

        public void setPhones(Set<String> phones) {
            this.phones = phones;
        }

        public EnumSet<Role> getRoles() {
            return this.roles;
        }

        public void setRoles(EnumSet<Role> roles) {
            this.roles = roles;
        }

        public Set<Child> getChildren() {
            return this.children;
        }

        public void setChildren(Set<Child> children) {
            this.children = children;
        }
    }

    public static enum Role {
        USER,
        ADMIN,
        DEV;

    }

    public static class Child
    implements Serializable {
        private final String name;
        private final Integer age;
        private final Set<String> toys;

        @ConstructorProperties(value={"name", "age", "toys"})
        public Child(String name, Integer age, Set<String> toys) {
            this.name = Objects.requireNonNull(name);
            this.age = Objects.requireNonNull(age);
            this.toys = Objects.requireNonNull(toys);
        }

        public String getName() {
            return this.name;
        }

        public Integer getAge() {
            return this.age;
        }

        public Set<String> getToys() {
            return this.toys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Child child = (Child)o;
            if (!this.name.equals(child.name)) {
                return false;
            }
            if (!this.age.equals(child.age)) {
                return false;
            }
            return this.toys.equals(child.toys);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.age.hashCode();
            result = 31 * result + this.toys.hashCode();
            return result;
        }
    }
}

