/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonBinaryTypeNestedCollectionNoEqualsTest
extends AbstractPostgreSQLIntegrationTest {
    private Post _post;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Post.class};
    }

    @Override
    protected void afterInit() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            ArrayList<String> attributes = new ArrayList<String>();
            attributes.add("JPA");
            attributes.add("Hibernate");
            PostAttributes customAttributes = new PostAttributes();
            customAttributes.setAttributes(attributes);
            Post post = new Post();
            post.setCustomAttributes(customAttributes);
            entityManager.persist((Object)post);
            this._post = post;
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertInsertCount((int)1);
    }

    @Test
    public void testLoad() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Post post = (Post)entityManager.find(Post.class, (Object)this._post.getId());
            List<String> attributes = post.getCustomAttributes().getAttributes();
            Assert.assertTrue((boolean)attributes.contains("JPA"));
            Assert.assertTrue((boolean)attributes.contains("Hibernate"));
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertSelectCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    @Entity(name="Post")
    @Table(name="post")
    public static class Post {
        @GeneratedValue(strategy=GenerationType.IDENTITY)
        @Id
        private Long id;
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private PostAttributes customAttributes;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public PostAttributes getCustomAttributes() {
            return this.customAttributes;
        }

        public void setCustomAttributes(PostAttributes customAttributes) {
            this.customAttributes = customAttributes;
        }
    }

    public static class PostAttributes {
        private List<String> attributes;

        public List<String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(List<String> attributes) {
            this.attributes = attributes;
        }
    }
}

