/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import io.hypersistence.utils.hibernate.type.model.Event;
import io.hypersistence.utils.hibernate.type.model.Location;
import io.hypersistence.utils.hibernate.type.model.Participant;
import io.hypersistence.utils.hibernate.type.model.Ticket;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLJsonBinaryTypeLazyGroupTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class, Participant.class};
    }

    @Test
    public void test() {
        AtomicReference eventHolder = new AtomicReference();
        AtomicReference participantHolder = new AtomicReference();
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Location location = new Location();
            location.setCountry("Romania");
            location.setCity("Cluj-Napoca");
            Event event = new Event();
            event.setId(1L);
            event.setLocation(location);
            entityManager.persist((Object)event);
            Ticket ticket = new Ticket();
            ticket.setPrice(12.34);
            ticket.setRegistrationCode("ABC123");
            Participant participant = new Participant();
            participant.setId(1L);
            participant.setTicket(ticket);
            participant.setEvent(event);
            entityManager.persist((Object)participant);
            eventHolder.set(event);
            participantHolder.set(participant);
        });
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)((Event)eventHolder.get()).getId());
            this.LOGGER.debug("Fetched event");
            Assert.assertEquals((Object)"Cluj-Napoca", (Object)event.getLocation().getCity());
            Participant participant = (Participant)entityManager.find(Participant.class, (Object)((Participant)participantHolder.get()).getId());
            this.LOGGER.debug("Fetched participant");
            Assert.assertEquals((Object)"ABC123", (Object)participant.getTicket().getRegistrationCode());
        });
    }
}

