/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.type.model.Location;
import io.hypersistence.utils.hibernate.type.model.Ticket;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.util.Arrays;
import java.util.List;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLGenericJsonBinaryTypeTest
extends AbstractPostgreSQLIntegrationTest {
    private Event _event;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class, Participant.class};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            Location cluj = new Location();
            cluj.setCountry("Romania");
            cluj.setCity("Cluj-Napoca");
            Location newYork = new Location();
            newYork.setCountry("US");
            newYork.setCity("New-York");
            Location london = new Location();
            london.setCountry("UK");
            london.setCity("London");
            Event event = new Event();
            event.setId(1L);
            event.setLocation(cluj);
            event.setAlternativeLocations(Arrays.asList(newYork, london));
            entityManager.persist((Object)event);
            this._event = event;
        });
    }

    @Test
    public void test() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            Assert.assertEquals((Object)"Cluj-Napoca", (Object)event.getLocation().getCity());
            Assert.assertEquals((long)2L, (long)event.getAlternativeLocations().size());
            Assert.assertEquals((Object)"New-York", (Object)event.getAlternativeLocations().get(0).getCity());
            Assert.assertEquals((Object)"London", (Object)event.getAlternativeLocations().get(1).getCity());
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertSelectCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    @Entity(name="Event")
    @Table(name="event")
    public static class Event
    extends BaseEntity {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private Location location;
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private List<Location> alternativeLocations;

        public Location getLocation() {
            return this.location;
        }

        public void setLocation(Location location) {
            this.location = location;
        }

        public List<Location> getAlternativeLocations() {
            return this.alternativeLocations;
        }

        public void setAlternativeLocations(List<Location> alternativeLocations) {
            this.alternativeLocations = alternativeLocations;
        }
    }

    @Entity(name="Participant")
    @Table(name="participant")
    public static class Participant
    extends BaseEntity {
        @Type(value=JsonBinaryType.class)
        @Column(columnDefinition="jsonb")
        private Ticket ticket;
        @ManyToOne
        private Event event;

        public Ticket getTicket() {
            return this.ticket;
        }

        public void setTicket(Ticket ticket) {
            this.ticket = ticket;
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }
    }
}

