/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import io.hypersistence.utils.hibernate.type.json.JsonStringType;
import io.hypersistence.utils.hibernate.util.AbstractMySQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class MySQLJsonStringPropertyTest
extends AbstractMySQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Book().setIsbn("978-9730228236").setProperties("{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99}")));
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            SQLStatementCountValidator.reset();
            book.setProperties("{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99,   \"url\": \"https://www.amazon.com/High-Performance-Java-Persistence-Vlad-Mihalcea/dp/973022823X/\"}");
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)1);
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            Book book = (Book)session.bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertTrue((boolean)book.getProperties().contains("\"price\": 44.99"));
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertSelectCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    @Test
    public void testNullValue() {
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            SQLStatementCountValidator.reset();
            book.setProperties(null);
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)1);
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertNull((Object)book.getProperties());
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        @Type(value=JsonStringType.class)
        @Column(columnDefinition="json")
        private String properties;

        public String getIsbn() {
            return this.isbn;
        }

        public Book setIsbn(String isbn) {
            this.isbn = isbn;
            return this;
        }

        public String getProperties() {
            return this.properties;
        }

        public Book setProperties(String properties) {
            this.properties = properties;
            return this;
        }
    }
}

