/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import com.fasterxml.jackson.databind.JsonNode;
import io.hypersistence.utils.hibernate.type.json.JsonNodeBinaryType;
import io.hypersistence.utils.hibernate.type.json.JsonNodeStringType;
import io.hypersistence.utils.hibernate.type.json.JsonStringType;
import io.hypersistence.utils.hibernate.type.json.internal.JacksonUtil;
import io.hypersistence.utils.hibernate.util.AbstractMySQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.Table;
import java.util.Collections;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.hibernate.usertype.UserType;
import org.junit.Assert;
import org.junit.Test;

public class MySQLJsonNodeTypeTest
extends AbstractMySQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.metadata_builder_contributor", metadataBuilder -> metadataBuilder.applyBasicType((UserType)JsonNodeBinaryType.INSTANCE, new String[0]));
        properties.put("hibernate.type_contributors", () -> Collections.singletonList((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)new JsonStringType(JsonNode.class))));
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setIsbn("978-9730228236");
            book.setProperties(JacksonUtil.toJsonNode((String)"{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99}"));
            entityManager.persist((Object)book);
        });
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            Book book = (Book)session.bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            SQLStatementCountValidator.reset();
            book.setProperties(JacksonUtil.toJsonNode((String)"{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99,   \"url\": \"https://www.amazon.com/High-Performance-Java-Persistence-Vlad-Mihalcea/dp/973022823X/\"}"));
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)1);
    }

    @Test
    public void testLoad() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            Book book = (Book)session.bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertEquals((Object)this.expectedPrice(), (Object)book.getProperties().get("price").asText());
        });
        SQLStatementCountValidator.assertTotalCount((int)1);
        SQLStatementCountValidator.assertSelectCount((int)1);
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    @Test
    public void testQueryByJsonNode() {
        Book book = (Book)this.doInJPA(entityManager -> {
            Session session = (Session)entityManager.unwrap(Session.class);
            return (Book)session.bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
        });
        this.doInJPA(entityManager -> {
            String isbn = (String)entityManager.createNativeQuery("select isbn from book where properties = CAST(:properties AS JSON)").setParameter("properties", (Object)book.getProperties()).getSingleResult();
            Assert.assertEquals((Object)book.getIsbn(), (Object)isbn);
        });
    }

    protected String initialPrice() {
        return "44.99";
    }

    protected String expectedPrice() {
        return "44.99";
    }

    @Entity(name="Book")
    @Table(name="book")
    @SqlResultSetMapping(name="BookDTO", classes={@ConstructorResult(targetClass=BookDTO.class, columns={@ColumnResult(name="id"), @ColumnResult(name="properties", type=JsonNode.class)})})
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        @Type(value=JsonNodeStringType.class)
        @Column(columnDefinition="json")
        private JsonNode properties;

        public String getIsbn() {
            return this.isbn;
        }

        public void setIsbn(String isbn) {
            this.isbn = isbn;
        }

        public JsonNode getProperties() {
            return this.properties;
        }

        public void setProperties(JsonNode properties) {
            this.properties = properties;
        }
    }

    public static class BookDTO {
        private long id;
        private JsonNode properties;

        public BookDTO() {
        }

        public BookDTO(Number id, JsonNode properties) {
            this.id = id.longValue();
            this.properties = properties;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Number id) {
            this.id = id.longValue();
        }

        public JsonNode getProperties() {
            return this.properties;
        }

        public void setProperties(JsonNode properties) {
            this.properties = properties;
        }
    }
}

