/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import io.hypersistence.utils.hibernate.util.AbstractMySQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class MySQLJsonNodePropertyTest
extends AbstractMySQLIntegrationTest {
    private final ObjectMapper mapper = MySQLJsonNodePropertyTest.newMapper();

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            try {
                entityManager.persist((Object)new Book().setIsbn("978-9730228236").setProperties(this.mapper.readTree("{\"field\": 0.05}")));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    @Test
    public void test() {
        SQLStatementCountValidator.reset();
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertEquals((double)0.05, (double)book.getProperties().get("field").asDouble(), (double)0.0);
        });
        SQLStatementCountValidator.assertUpdateCount((int)0);
    }

    private static ObjectMapper newMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        return mapper;
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        @Type(value=MyJsonType.class)
        @Column(columnDefinition="json")
        private JsonNode properties;

        public String getIsbn() {
            return this.isbn;
        }

        public Book setIsbn(String isbn) {
            this.isbn = isbn;
            return this;
        }

        public JsonNode getProperties() {
            return this.properties;
        }

        public Book setProperties(JsonNode properties) {
            this.properties = properties;
            return this;
        }
    }

    public static class MyJsonType
    extends JsonType {
        public MyJsonType() {
            super(MySQLJsonNodePropertyTest.newMapper());
        }
    }
}

