/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.json;

import com.fasterxml.jackson.databind.JsonNode;
import io.hypersistence.utils.hibernate.type.json.JsonNodeStringType;
import io.hypersistence.utils.hibernate.type.json.internal.JacksonUtil;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.type.model.Location;
import io.hypersistence.utils.hibernate.type.model.Ticket;
import io.hypersistence.utils.hibernate.util.AbstractMySQLIntegrationTest;
import io.hypersistence.utils.jdbc.validator.SQLStatementCountValidator;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.List;
import java.util.Properties;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class EhcacheMySQLJsonBinaryTypeTest
extends AbstractMySQLIntegrationTest {
    private Event _event;

    @Override
    protected Class<?>[] entities() {
        return new Class[]{Event.class};
    }

    @Override
    protected String[] packages() {
        return new String[]{Event.class.getPackage().getName()};
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.setProperty("hibernate.cache.use_second_level_cache", "true");
        properties.setProperty("hibernate.cache.use_query_cache", "true");
        properties.setProperty("hibernate.cache.region.factory_class", "jcache");
    }

    @Override
    protected void afterInit() {
        this.doInJPA(entityManager -> {
            Event nullEvent = new Event();
            nullEvent.setId(0L);
            entityManager.persist((Object)nullEvent);
            Location location = new Location();
            location.setCountry("Romania");
            location.setCity("Cluj-Napoca");
            Event event = new Event();
            event.setId(1L);
            event.setProperties(JacksonUtil.toJsonNode((String)"{   \"title\": \"High-Performance Java Persistence\",   \"author\": \"Vlad Mihalcea\",   \"publisher\": \"Amazon\",   \"price\": 44.99}"));
            entityManager.persist((Object)event);
            Ticket ticket = new Ticket();
            ticket.setPrice(12.34);
            ticket.setRegistrationCode("ABC123");
            this._event = event;
        });
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            SQLStatementCountValidator.reset();
            Event event = (Event)entityManager.find(Event.class, (Object)this._event.getId());
            Assert.assertNotNull((Object)event.getProperties());
            SQLStatementCountValidator.assertTotalCount((int)0);
            List properties = entityManager.createNativeQuery("select CAST(e.properties AS CHAR(1000)) from event e where JSON_EXTRACT(e.properties, \"$.price\") > :price ").setParameter("price", (Object)1).getResultList();
            Assert.assertEquals((long)1L, (long)properties.size());
            JsonNode jsonNode = JacksonUtil.toJsonNode((String)((String)properties.get(0)));
            Assert.assertEquals((Object)"High-Performance Java Persistence", (Object)jsonNode.get("title").asText());
        });
    }

    @Entity(name="Event")
    @Table(name="event")
    @Cacheable(value=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public static class Event
    extends BaseEntity {
        @Type(value=JsonNodeStringType.class)
        @Column(columnDefinition="json")
        private JsonNode properties;

        public JsonNode getProperties() {
            return this.properties;
        }

        public void setProperties(JsonNode properties) {
            this.properties = properties;
        }
    }
}

