/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.interval;

import io.hypersistence.utils.hibernate.type.interval.PostgreSQLPeriodType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import java.time.Period;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLPeriodTypeTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{WorkShift.class};
    }

    @Test
    public void test() {
        Period duration = Period.of(1, 2, 3);
        this.doInJPA(entityManager -> {
            WorkShift intervalEntity = new WorkShift();
            intervalEntity.setId(1L);
            intervalEntity.setDuration(duration);
            entityManager.persist((Object)intervalEntity);
        });
        this.doInJPA(entityManager -> {
            WorkShift result = (WorkShift)entityManager.find(WorkShift.class, (Object)1L);
            Assert.assertEquals((Object)duration, (Object)result.getDuration());
        });
    }

    @Entity(name="WorkShift")
    public static class WorkShift
    extends BaseEntity {
        @Type(value=PostgreSQLPeriodType.class)
        @Column(columnDefinition="interval")
        private Period duration;

        public Period getDuration() {
            return this.duration;
        }

        public void setDuration(Period duration) {
            this.duration = duration;
        }
    }
}

