/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.interval;

import io.hypersistence.utils.hibernate.type.interval.OracleIntervalDayToSecondType;
import io.hypersistence.utils.hibernate.type.model.BaseEntity;
import io.hypersistence.utils.hibernate.util.AbstractOracleIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import java.time.Duration;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class OracleIntervalDayToSecondTypeTest
extends AbstractOracleIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{WorkShift.class};
    }

    @Test
    public void test() {
        Duration duration = Duration.ofDays(1L).plusHours(2L).plusMinutes(3L).plusSeconds(4L);
        this.doInJPA(entityManager -> {
            WorkShift intervalEntity = new WorkShift();
            intervalEntity.setId(1L);
            intervalEntity.setDuration(duration);
            entityManager.persist((Object)intervalEntity);
        });
        this.doInJPA(entityManager -> {
            WorkShift result = (WorkShift)entityManager.find(WorkShift.class, (Object)1L);
            Assert.assertEquals((Object)duration, (Object)result.getDuration());
        });
    }

    @Entity(name="WorkShift")
    public static class WorkShift
    extends BaseEntity {
        @Type(value=OracleIntervalDayToSecondType.class)
        @Column(columnDefinition="INTERVAL DAY TO SECOND")
        private Duration duration;

        public Duration getDuration() {
            return this.duration;
        }

        public void setDuration(Duration duration) {
            this.duration = duration;
        }
    }
}

