/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.binary;

import io.hypersistence.utils.hibernate.util.AbstractMySQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.junit.Assert;
import org.junit.Test;

public class MySQLBinaryTypeTest
extends AbstractMySQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Post.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> entityManager.persist((Object)new Post().setTitle("High-Performance Java Persistence").setImage(new byte[]{1, 2, 3})));
        this.doInJPA(entityManager -> {
            Post post = (Post)entityManager.find(Post.class, (Object)1L);
            Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3}, (byte[])post.getImage());
        });
    }

    @Entity(name="Post")
    @Table(name="post")
    public static class Post {
        @Id
        @GeneratedValue
        private Long id;
        private String title;
        @Column(columnDefinition="BINARY(3)")
        private byte[] image;

        public Long getId() {
            return this.id;
        }

        public Post setId(Long id) {
            this.id = id;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public Post setTitle(String title) {
            this.title = title;
            return this;
        }

        public byte[] getImage() {
            return this.image;
        }

        public Post setImage(byte[] image) {
            this.image = image;
            return this;
        }
    }
}

