/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.ZoneIdType;
import io.hypersistence.utils.hibernate.util.AbstractMySQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.ZoneId;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class ZoneIdTest
extends AbstractMySQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{UserPreferences.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            UserPreferences UserPreferences2 = new UserPreferences();
            UserPreferences2.setName("vladmihalcea.com");
            UserPreferences2.setZoneId(ZoneId.of("Europe/Bucharest"));
            entityManager.persist((Object)UserPreferences2);
        });
        this.doInJPA(entityManager -> {
            UserPreferences userPreferences = (UserPreferences)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(UserPreferences.class).load((Object)"vladmihalcea.com");
            Assert.assertEquals((Object)ZoneId.of("Europe/Bucharest"), (Object)userPreferences.getZoneId());
        });
        this.doInJPA(entityManager -> {
            UserPreferences prefs = (UserPreferences)entityManager.createQuery("select p from UserPreferences p where  p.zoneId = :zoneId", UserPreferences.class).setParameter("zoneId", (Object)ZoneId.of("Europe/Bucharest")).getSingleResult();
            Assert.assertEquals((Object)"vladmihalcea.com", (Object)prefs.getName());
        });
    }

    @Entity(name="UserPreferences")
    @Table(name="user_preferences")
    public static class UserPreferences {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String name;
        @Type(value=ZoneIdType.class)
        @Column(name="zone_id", length=40)
        private ZoneId zoneId;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ZoneId getZoneId() {
            return this.zoneId;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }
    }
}

