/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.YearType;
import io.hypersistence.utils.hibernate.util.AbstractMySQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.Month;
import java.time.Year;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.junit.Assert;
import org.junit.Test;

public class YearAndMonthTest
extends AbstractMySQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Publisher.class};
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Publisher publisher = new Publisher();
            publisher.setName("vladmihalcea.com");
            publisher.setEstYear(Year.of(2013));
            publisher.setSalesMonth(Month.NOVEMBER);
            entityManager.persist((Object)publisher);
        });
        this.doInJPA(entityManager -> {
            Publisher publisher = (Publisher)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Publisher.class).load((Object)"vladmihalcea.com");
            Assert.assertEquals((Object)Year.of(2013), (Object)publisher.getEstYear());
            Assert.assertEquals((Object)Month.NOVEMBER, (Object)publisher.getSalesMonth());
        });
        this.doInJPA(entityManager -> {
            Publisher book = (Publisher)entityManager.createQuery("select p from Publisher p where    p.estYear = :estYear and    p.salesMonth = :salesMonth", Publisher.class).setParameter("estYear", (Object)Year.of(2013)).setParameter("salesMonth", (Object)Month.NOVEMBER).getSingleResult();
            Assert.assertEquals((Object)"vladmihalcea.com", (Object)book.getName());
        });
    }

    @Entity(name="Publisher")
    @Table(name="publisher")
    public static class Publisher {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String name;
        @Type(value=YearType.class)
        @Column(name="est_year", columnDefinition="smallint")
        private Year estYear;
        @Column(name="sales_month", columnDefinition="smallint")
        @Enumerated
        private Month salesMonth;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Year getEstYear() {
            return this.estYear;
        }

        public void setEstYear(Year estYear) {
            this.estYear = estYear;
        }

        public Month getSalesMonth() {
            return this.salesMonth;
        }

        public void setSalesMonth(Month salesMonth) {
            this.salesMonth = salesMonth;
        }
    }
}

