/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.YearMonthIntegerType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.YearMonth;
import java.util.Collections;
import java.util.Properties;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.usertype.UserType;
import org.junit.Assert;
import org.junit.Test;

public class PostgreSQLYearMonthIntegerTypeContributorTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.type_contributors", () -> Collections.singletonList((typeContributions, serviceRegistry) -> typeContributions.contributeType((UserType)YearMonthIntegerType.INSTANCE)));
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setIsbn("978-9730228236");
            book.setTitle("High-Performance Java Persistence");
            book.setPublishedOn(YearMonth.of(2016, 10));
            entityManager.persist((Object)book);
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertEquals((Object)YearMonth.of(2016, 10), (Object)book.getPublishedOn());
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)entityManager.createQuery("select b from Book b where    b.title = :title and    b.publishedOn = :publishedOn", Book.class).setParameter("title", (Object)"High-Performance Java Persistence").setParameter("publishedOn", (Object)YearMonth.of(2016, 10)).getSingleResult();
            Assert.assertEquals((Object)"978-9730228236", (Object)book.getIsbn());
        });
    }

    @Entity(name="Book")
    @Table(name="book")
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        private String title;
        @Column(name="published_on", columnDefinition="integer")
        private YearMonth publishedOn;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getIsbn() {
            return this.isbn;
        }

        public void setIsbn(String isbn) {
            this.isbn = isbn;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public YearMonth getPublishedOn() {
            return this.publishedOn;
        }

        public void setPublishedOn(YearMonth publishedOn) {
            this.publishedOn = publishedOn;
        }
    }
}

