/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.basic.YearMonthEpochType;
import io.hypersistence.utils.hibernate.util.AbstractPostgreSQLIntegrationTest;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import java.time.YearMonth;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.Type;
import org.hibernate.query.BindableType;
import org.hibernate.query.NativeQuery;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class PostgreSQLYearMonthEpochTest
extends AbstractPostgreSQLIntegrationTest {
    @Override
    protected Class<?>[] entities() {
        return new Class[]{Book.class};
    }

    @Override
    protected void additionalProperties(Properties properties) {
        properties.put("hibernate.jdbc.batch_size", (Object)50);
    }

    @Test
    public void test() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setIsbn("978-9730228236");
            book.setTitle("High-Performance Java Persistence");
            book.setPublishedOn(YearMonth.of(2016, 10));
            entityManager.persist((Object)book);
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"978-9730228236");
            Assert.assertEquals((Object)YearMonth.of(2016, 10), (Object)book.getPublishedOn());
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)entityManager.createQuery("select b from Book b where    b.title = :title and    b.publishedOn = :publishedOn", Book.class).setParameter("title", (Object)"High-Performance Java Persistence").setParameter("publishedOn", (Object)YearMonth.of(2016, 10)).getSingleResult();
            Assert.assertEquals((Object)"978-9730228236", (Object)book.getIsbn());
        });
    }

    @Test
    public void testNull() {
        this.doInJPA(entityManager -> {
            Book book = new Book();
            book.setIsbn("123-456");
            book.setPublishedOn(null);
            entityManager.persist((Object)book);
        });
        this.doInJPA(entityManager -> {
            Book book = (Book)((Session)entityManager.unwrap(Session.class)).bySimpleNaturalId(Book.class).load((Object)"123-456");
            Assert.assertNull((Object)book.getPublishedOn());
        });
    }

    @Test
    @Ignore
    public void testIndexing() {
        this.doInJPA(entityManager -> {
            YearMonth yearMonth = YearMonth.of(1970, 1);
            for (int i = 0; i < 5000; ++i) {
                yearMonth = yearMonth.plusMonths(1L);
                Book book = new Book();
                book.setTitle(String.format("IT industry newsletter - %s edition", yearMonth));
                book.setPublishedOn(yearMonth);
                entityManager.persist((Object)book);
            }
        });
        List executionPlanLines = (List)this.doInJPA(entityManager -> ((NativeQuery)entityManager.createNativeQuery("EXPLAIN ANALYZE SELECT     b.published_on FROM     book b WHERE    b.published_on BETWEEN :startYearMonth AND :endYearMonth ").unwrap(NativeQuery.class)).setParameter("startYearMonth", (Object)YearMonth.of(2010, 12), (BindableType)YearMonthEpochType.INSTANCE).setParameter("endYearMonth", (Object)YearMonth.of(2018, 1), (BindableType)YearMonthEpochType.INSTANCE).getResultList());
        this.LOGGER.info("Execution plan: \n{}", (Object)executionPlanLines.stream().collect(Collectors.joining("\n")));
    }

    @Entity(name="Book")
    @Table(name="book", indexes={@Index(name="idx_book_published_on", columnList="published_on")})
    public static class Book {
        @Id
        @GeneratedValue
        private Long id;
        @NaturalId
        private String isbn;
        private String title;
        @Type(value=YearMonthEpochType.class)
        @Column(name="published_on", columnDefinition="integer")
        private YearMonth publishedOn;

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getIsbn() {
            return this.isbn;
        }

        public void setIsbn(String isbn) {
            this.isbn = isbn;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public YearMonth getPublishedOn() {
            return this.publishedOn;
        }

        public void setPublishedOn(YearMonth publishedOn) {
            this.publishedOn = publishedOn;
        }
    }
}

